/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class DeletePullRequestErrorTranslator
extends DefaultErrorTranslator {
    private final long pullRequestId;

    DeletePullRequestErrorTranslator(@Nonnull I18nService i18nService, @Nonnull Repository repository, long pullRequestId) {
        super(i18nService, Objects.requireNonNull(repository, "repository"));
        this.pullRequestId = pullRequestId;
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, Throwable cause) {
        if (Objects.requireNonNull(error, "error").getErrorOneofCase() == RpcGitError.ErrorOneofCase.DELETE_PULL_REQUEST_FAILED) {
            return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.pullrequest.delete.failed", new Object[]{this.pullRequestId, this.repository.getProject().getKey(), this.repository.getSlug()}));
        }
        return super.translate(error, cause);
    }
}

