/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DeleteRefErrorTranslator
extends DefaultErrorTranslator {
    public DeleteRefErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    protected ServiceException translate(RpcGitError error, Throwable cause) {
        if (error.getErrorOneofCase() == RpcGitError.ErrorOneofCase.NO_SUCH_REF) {
            String refId = error.getNoSuchRef().getRefName().toStringUtf8();
            return new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.repository.deleteref.nosuchref", new Object[]{refId}), refId);
        }
        return super.translate(error, cause);
    }
}

