/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.NoSuchTagException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DeleteTagErrorTranslator
extends DefaultErrorTranslator {
    public DeleteTagErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        if (error.getErrorOneofCase() == RpcGitError.ErrorOneofCase.NO_SUCH_OBJECT) {
            String tag = error.getNoSuchObject().getObjectId().toStringUtf8();
            return new NoSuchTagException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.notfound", new Object[]{tag, this.repository.getName()}), tag);
        }
        return super.translate(error, cause);
    }
}

