/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffEvent;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStreamRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;

class DiffResponseObserver
extends AbstractFutureResponseObserver<RpcDiffStreamRequest, RpcDiffResponseFragment, Void> {
    private final DiffContentCallback callback;
    private final DiffContext diffContext;
    private final I18nService i18nService;
    private volatile ClientCallStreamObserver<RpcDiffStreamRequest> requestStream;
    private volatile Throwable thrown;

    DiffResponseObserver(@Nonnull DiffContentCallback callback, @Nonnull DiffContext diffContext, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.diffContext = Objects.requireNonNull(diffContext, "diffContext");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcDiffStreamRequest> requestStream) {
        this.fireOnStart();
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcDiffResponseFragment fragment) {
        try {
            for (RpcDiffEvent response : fragment.getEventsList()) {
                this.handleEvent(response);
            }
        }
        catch (IOException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Path createPath(ByteString path) {
        return path == null || path.isEmpty() ? null : new SimplePath((CharSequence)path.toStringUtf8());
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            this.callback.onEnd(new DiffSummary.Builder(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED).build());
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart(this.diffContext);
        }
        catch (IOException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private void handleEvent(RpcDiffEvent response) throws IOException {
        if (response.hasOnBinary()) {
            RpcDiffEvent.OnBinary onBinary = response.getOnBinary();
            this.callback.onBinary(this.createPath(onBinary.getSrc()), this.createPath(onBinary.getDst()));
        } else if (response.hasOnDiffEnd()) {
            RpcDiffEvent.OnDiffEnd onDiffEnd = response.getOnDiffEnd();
            this.callback.onDiffEnd(onDiffEnd.getTruncated());
        } else if (response.hasOnDiffStart()) {
            RpcDiffEvent.OnDiffStart onDiffStart = response.getOnDiffStart();
            this.callback.onDiffStart(this.createPath(onDiffStart.getSrc()), this.createPath(onDiffStart.getDst()));
        } else if (response.hasOnHunkEnd()) {
            RpcDiffEvent.OnHunkEnd onHunkEnd = response.getOnHunkEnd();
            this.callback.onHunkEnd(onHunkEnd.getTruncated());
        } else if (response.hasOnHunkStart()) {
            RpcDiffEvent.OnHunkStart onHunkStart = response.getOnHunkStart();
            this.callback.onHunkStart(onHunkStart.getSrcLine(), onHunkStart.getSrcSpan(), onHunkStart.getDstLine(), onHunkStart.getDstSpan(), ByteStringUtils.emptyToNull((ByteString)onHunkStart.getContext()));
        } else if (response.hasOnSegmentEnd()) {
            RpcDiffEvent.OnSegmentEnd onSegmentEnd = response.getOnSegmentEnd();
            this.callback.onSegmentEnd(onSegmentEnd.getTruncated());
        } else if (response.hasOnSegmentStart()) {
            RpcDiffEvent.OnSegmentStart onSegmentStart = response.getOnSegmentStart();
            this.callback.onSegmentStart(this.mapDiffType(onSegmentStart.getType()));
        } else if (response.hasOnSegmentLine()) {
            RpcDiffEvent.OnSegmentLine onSegmentLine = response.getOnSegmentLine();
            this.callback.onSegmentLine(onSegmentLine.getLine().toStringUtf8(), null, onSegmentLine.getTruncated());
        }
    }

    private DiffSegmentType mapDiffType(RpcDiffEvent.DiffSegmentType type) {
        return switch (type) {
            case RpcDiffEvent.DiffSegmentType.ADDED -> DiffSegmentType.ADDED;
            case RpcDiffEvent.DiffSegmentType.CONTEXT -> DiffSegmentType.CONTEXT;
            case RpcDiffEvent.DiffSegmentType.REMOVED -> DiffSegmentType.REMOVED;
            default -> throw new IllegalArgumentException("Unknown diff segment type: " + String.valueOf(type));
        };
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

