/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDrainRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDrainResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDrainedResource;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrainResponseObserver
extends AbstractFutureResponseObserver<RpcDrainRequest, RpcDrainResponseFragment, Void> {
    private static final Logger log = LoggerFactory.getLogger(DrainResponseObserver.class);
    private final MeshNode node;

    public DrainResponseObserver(MeshNode node) {
        this.node = node;
    }

    public void onNext(RpcDrainResponseFragment fragment) {
        if (fragment.hasDrainedResource()) {
            this.onDrained(fragment.getDrainedResource());
        }
    }

    protected void onDrained(RpcDrainedResource resource) {
        if (log.isDebugEnabled()) {
            if (resource.hasHierarchy()) {
                log.debug("Drained hierarchy {} on {}", (Object)resource.getHierarchy(), (Object)this.node);
            } else {
                String partition = resource.getPartition();
                if (StringUtils.isNotBlank((CharSequence)partition)) {
                    log.debug("Drained partition {} on {}", (Object)resource.getPartition(), (Object)this.node);
                } else {
                    log.debug("Drained node {}", (Object)this.node);
                }
            }
        }
    }
}

