/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.content.EditFileFailedException;
import com.atlassian.bitbucket.content.FileAlreadyExistsException;
import com.atlassian.bitbucket.content.FileContentUnmodifiedException;
import com.atlassian.bitbucket.content.FileOutOfDateException;
import com.atlassian.bitbucket.content.FileTranscodingException;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcEditFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidEditFile;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTranscodingFailed;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.mesh.CreateBranchErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class EditFileErrorTranslator
extends CreateBranchErrorTranslator {
    private final RpcEditFileRequest request;

    public EditFileErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository, @Nonnull RpcEditFileRequest request) {
        super(i18nService, repository);
        this.request = Objects.requireNonNull(request, "request");
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case EDIT_FILE_FAILED: {
                return this.editFileFailed();
            }
            case INVALID_EDIT_FILE: {
                return this.translate(error.getInvalidEditFile(), error, cause);
            }
            case TRANSCODING_FAILED: {
                return this.translate(error.getTranscodingFailed(), cause);
            }
            case WORK_TREE_WRITE_FAILED: {
                return this.editFileFailed();
            }
        }
        return super.translate(error, cause);
    }

    private ServiceException editFileFailed() {
        return new EditFileFailedException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.failed", new Object[0]));
    }

    private ServiceException translate(RpcInvalidEditFile invalidEditFile, RpcGitError error, Throwable cause) {
        String path = this.request.getPath().toStringUtf8();
        String commit = this.request.getSourceCommitish().toStringUtf8();
        switch (invalidEditFile.getReason()) {
            case EDIT_FILE_DELETED: {
                return new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.deleted", new Object[]{path, commit}), path, commit);
            }
            case EDIT_FILE_EXISTS: {
                return new FileAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.exists", new Object[]{path}));
            }
            case EDIT_FILE_NO_BRANCH: {
                return this.editFileFailed();
            }
            case EDIT_FILE_NONEXISTENT: {
                return new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.nonexistent", new Object[]{path, commit}), path, commit);
            }
            case EDIT_FILE_PATH: {
                return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.path", new Object[0]));
            }
            case EDIT_FILE_SAME: {
                return new FileContentUnmodifiedException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.same", new Object[0]));
            }
            case EDIT_FILE_STALE: {
                String branch = GitRefPattern.HEADS.unqualify(this.request.getBranch().getId().toStringUtf8());
                return new FileOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.stale", new Object[]{path, branch}));
            }
        }
        return this.translateDefault(error, cause);
    }

    private ServiceException translate(RpcTranscodingFailed transcodingFailed, Throwable cause) {
        return new FileTranscodingException(this.i18nService.createKeyedMessage("bitbucket.git.edit.file.transcodefailed", new Object[]{transcodingFailed.getSource(), transcodingFailed.getTarget()}), cause);
    }
}

