/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.content.FileEditHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcEditFileFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcEditFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcEditFileResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcEditFileResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFileContent;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRunEditFileHooks;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRef;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.EditFileErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.common.io.ByteStreams;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditFileResponseObserver
extends AbstractFutureResponseObserver<RpcEditFileFragment, RpcEditFileResponseFragment, Commit> {
    private static final Logger log = LoggerFactory.getLogger(EditFileResponseObserver.class);
    private final InputSupplier<InputStream> content;
    private final RepositoryHookService hookService;
    private final I18nService i18nService;
    private final Object monitor;
    private final Repository repository;
    private final RpcEditFileRequest request;
    private final GitRequestHelper requestHelper;
    private final MeshNode targetNode;

    public EditFileResponseObserver(RepositoryHookService hookService, I18nService i18nService, Repository repository, RpcEditFileRequest request, GitRequestHelper requestHelper, MeshNode targetNode, InputSupplier<InputStream> content) {
        super(new EditFileErrorTranslator(i18nService, repository, request));
        this.content = content;
        this.hookService = hookService;
        this.i18nService = i18nService;
        this.repository = repository;
        this.request = request;
        this.requestHelper = requestHelper;
        this.targetNode = targetNode;
        this.monitor = new Object();
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcEditFileFragment> requestStream) {
        super.beforeStart(requestStream);
        this.requestStream = requestStream;
        requestStream.setOnReadyHandler(() -> {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
            }
        });
    }

    public void onNext(RpcEditFileResponseFragment value) {
        switch (value.getResponseOneofCase()) {
            case RESPONSE: {
                this.parseResult(value.getResponse());
                break;
            }
            case RUN_HOOKS: {
                this.runHooks(value.getRunHooks());
                break;
            }
            default: {
                throw Status.INVALID_ARGUMENT.withDescription("Received [" + String.valueOf(value.getResponseOneofCase()) + "] where [" + String.valueOf(RpcEditFileResponseFragment.ResponseOneofCase.RUN_HOOKS) + "] was expected").asRuntimeException();
            }
        }
    }

    @Override
    Commit asResult() {
        this.requestStream.onNext((Object)RpcEditFileFragment.newBuilder().setRequest(this.request).build());
        this.streamContent();
        return (Commit)super.asResult();
    }

    private void parseResult(RpcEditFileResponse response) {
        RpcCommit commit = response.getCommit();
        this.setResult(RpcUtils.toCommit(commit, this.repository));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requireReady() {
        if (this.requestStream.isReady()) {
            return true;
        }
        Object object = this.monitor;
        synchronized (object) {
            while (!this.isCanceled() && !this.isDone()) {
                if (this.requestStream.isReady()) {
                    return true;
                }
                try {
                    this.monitor.wait(3000L);
                }
                catch (InterruptedException e) {
                    if (this.isCanceled()) {
                        log.debug("Canceled while writing file content");
                        return false;
                    }
                    Thread.currentThread().interrupt();
                    throw Status.ABORTED.withCause((Throwable)e).withDescription("Interrupted while writing file content").asRuntimeException();
                }
            }
            return false;
        }
    }

    private void runHooks(RpcRunEditFileHooks runHooks) {
        String commitId = runHooks.getCommitId();
        SimpleBranch branch = ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().id(GitRefPattern.HEADS.qualify(this.request.getTargetBranch().toStringUtf8()))).displayId(GitRefPattern.HEADS.unqualify(this.request.getTargetBranch().toStringUtf8()))).latestCommit(commitId)).build();
        String fromHash = this.request.hasBranch() && branch.getId().equals(this.request.getBranch().getId().toStringUtf8()) ? this.request.getBranch().getLatestCommit() : ShaUtils.NULL_SHA1;
        String path = this.request.getPath().toStringUtf8();
        FileEditHookRequest hookRequest = new FileEditHookRequest.Builder(this.repository, (Branch)branch, path, this.content).fromHash(fromHash).message(this.request.getMessage().toStringUtf8()).sourceCommitId(ByteStringUtils.emptyToNull((ByteString)this.request.getSourceCommitish())).toHash(commitId).build();
        RepositoryHookResult result = this.requestHelper.withQuarantine(this.repository, this.targetNode, runHooks.getRepository(), () -> this.hookService.preUpdate((RepositoryHookRequest)hookRequest));
        if (result.isRejected()) {
            super.onError((Throwable)new RepositoryHookVetoedException(this.i18nService.createKeyedMessage("bitbucket.scm.git.fileeditcanceled", new Object[]{this.request.getPath(), branch.getDisplayId()}), (RepositoryHookRequest)hookRequest, result.getVetoes()));
        } else {
            this.requestStream.onNext((Object)RpcEditFileFragment.newBuilder().setUpdateRef(RpcUpdateRef.getDefaultInstance()).build());
        }
        this.requestStream.onCompleted();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void streamContent() {
        try (InputStream stream = (InputStream)this.content.open();){
            int read;
            byte[] buffer = new byte[65536];
            do {
                read = ByteStreams.read((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
                if (!this.requireReady()) return;
                this.requestStream.onNext((Object)RpcEditFileFragment.newBuilder().setContent(RpcFileContent.newBuilder().setClosed(read < buffer.length).setData(ByteStringUtils.copyFrom((byte[])buffer, (int)0, (int)read))).build());
            } while (read >= buffer.length);
            return;
        }
        catch (IOException e) {
            this.requestStream.onError((Throwable)Status.ABORTED.withCause((Throwable)e).withDescription("Failed to copy file content").asRuntimeException());
        }
    }
}

