/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.MisconfiguredMeshClientDetectedEvent;
import com.atlassian.bitbucket.dmz.mesh.MissingRepositoryReplicaDetectedEvent;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.internal.mesh.RepositoryIdUtils;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcErrorUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNoSuchRepository;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNodeUnconfigured;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWrongTarget;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.concurrent.Gate;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.mesh.MeshController;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlingClientInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlingClientInterceptor.class);
    private static final long MIN_SECONDS_BETWEEN_CONFIG = 30L;
    private final Gate<Long> gate;
    private final EventPublisher eventPublisher;
    private final MeshController meshController;
    private final RepositorySupplier repositorySupplier;
    private final EscalatedSecurityContext withRepoRead;

    public ErrorHandlingClientInterceptor(EventPublisher eventPublisher, MeshController meshController, RepositorySupplier repositorySupplier, SecurityService securityService) {
        this.eventPublisher = eventPublisher;
        this.meshController = meshController;
        this.repositorySupplier = repositorySupplier;
        this.gate = new Gate(30L, TimeUnit.SECONDS);
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "ErrorHandlingClientInterceptor");
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall delegate = next.newCall(method, callOptions);
        MeshNode target = (MeshNode)callOptions.getOption(MeshConstants.OPT_TARGET_NODE);
        if (target == null) {
            return delegate;
        }
        return new ErrorHandlingCall(delegate, target);
    }

    private void onNodeUnconfigured(MeshNode node, RpcNodeUnconfigured error) {
        this.gate.callIfNotRecentlyRun((Object)node.getId(), () -> {
            try {
                log.info("Configuring node {} because it's been unconfigured for {}s", (Object)node, (Object)TimeUnit.MILLISECONDS.toSeconds(error.getUptime()));
                this.meshController.configure(node);
            }
            catch (RuntimeException e) {
                log.warn("Failed to reconfigure {}", (Object)node, (Object)e);
            }
        });
    }

    private void onNoSuchRepository(MeshNode node, RpcNoSuchRepository error) {
        Repository repository;
        String remoteId = error.getId();
        int localId = RepositoryIdUtils.getLocalRepositoryId((String)remoteId);
        if (localId != -1 && (repository = (Repository)this.withRepoRead.call(() -> this.repositorySupplier.getById(localId))) != null && repository.isRemote()) {
            this.eventPublisher.publish((Object)new MissingRepositoryReplicaDetectedEvent((Object)this, node, (DmzRepository)repository));
        }
    }

    private void onWrongTarget(MeshNode node, RpcWrongTarget error) {
        log.info("Mis-configured Mesh client detected for {}. The Mesh node at the resolved address has ID {} instead of {}. Has the IP address changed?", new Object[]{node, error.getActualId(), error.getTargetId()});
        this.eventPublisher.publish((Object)new MisconfiguredMeshClientDetectedEvent((Object)this, node));
    }

    private void onError(RpcError error, MeshNode target) {
        switch (error.getErrorOneofCase()) {
            case NODE_UNCONFIGURED: {
                this.onNodeUnconfigured(target, error.getNodeUnconfigured());
                break;
            }
            case NO_SUCH_REPOSITORY: {
                this.onNoSuchRepository(target, error.getNoSuchRepository());
                break;
            }
            case WRONG_TARGET: {
                this.onWrongTarget(target, error.getWrongTarget());
            }
        }
    }

    private class ErrorHandlingCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final MeshNode target;

        ErrorHandlingCall(ClientCall<ReqT, RespT> delegate, MeshNode target) {
            super(delegate);
            this.target = target;
        }

        public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
            this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(listener){

                public void onClose(Status status, Metadata trailers) {
                    try {
                        RpcError error;
                        if (!status.isOk() && (error = RpcErrorUtils.fromMetadata((Metadata)trailers)) != null) {
                            ErrorHandlingClientInterceptor.this.onError(error, ErrorHandlingCall.this.target);
                        }
                    }
                    catch (RuntimeException e) {
                        log.warn("Failed to handle RPC error", (Throwable)e);
                    }
                    this.delegate().onClose(status, trailers);
                }
            }, headers);
        }
    }
}

