/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AuthenticationFailedScmException;
import com.atlassian.bitbucket.scm.NotAuthorizedScmException;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchAuthenticationException;
import com.atlassian.bitbucket.scm.git.command.fetch.GitFetchAuthorisationException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class FetchErrorTranslator
extends DefaultErrorTranslator {
    FetchErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case REMOTE_AUTHENTICATION_FAILED: {
                String remoteUrl = error.getRemoteAuthenticationFailed().getUrl();
                KeyedMessage authcMessage = this.i18nService.createKeyedMessage("bitbucket.git.remote.authenticationerror", new Object[]{remoteUrl});
                return new AuthenticationFailedScmException(authcMessage, (Throwable)new GitFetchAuthenticationException(authcMessage, remoteUrl), "git");
            }
            case REMOTE_AUTHORIZATION_FAILED: {
                KeyedMessage authzMessage = this.i18nService.createKeyedMessage("bitbucket.git.remote.authorizationerror", new Object[0]);
                return new NotAuthorizedScmException(authzMessage, (Throwable)new GitFetchAuthorisationException(authzMessage), "git");
            }
        }
        return super.translate(error, cause);
    }
}

