/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFetchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFetchResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefUpdate;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.fetch.FetchCallback;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.FetchErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchResponseObserver
extends AbstractFutureResponseObserver<RpcFetchRequest, RpcFetchResponseFragment, Void> {
    private static final Logger log = LoggerFactory.getLogger(FetchResponseObserver.class);
    private final FetchCallback callback;
    private final I18nService i18nService;
    private final Repository repository;
    private volatile Throwable thrown;
    private volatile boolean callbackDone;

    public FetchResponseObserver(FetchCallback callback, I18nService i18nService, Repository repository) {
        super(new FetchErrorTranslator(i18nService, repository));
        this.callback = callback;
        this.i18nService = i18nService;
        this.repository = repository;
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcFetchRequest> requestStream) {
        this.fireOnStart();
        super.beforeStart(requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcFetchResponseFragment fragment) {
        if (this.callbackDone) {
            return;
        }
        for (RpcRefUpdate refUpdate : fragment.getRefUpdatesList()) {
            try {
                boolean bl = this.callbackDone = !this.callback.onRefChange(RpcUtils.toRefChange(refUpdate));
                if (!this.callbackDone) continue;
                return;
            }
            catch (IOException e) {
                this.logCallbackException("onRefChange", e);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
        }
        for (String refId : ByteStringUtils.toStringsLazily((List)fragment.getFailedRefIdsList())) {
            try {
                boolean bl = this.callbackDone = !this.callback.onFailedRef(RpcUtils.toMinimalRef(refId));
                if (!this.callbackDone) continue;
                return;
            }
            catch (IOException e) {
                this.logCallbackException("onFailedRef", e);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            this.callback.onEnd(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED);
        }
        catch (IOException e) {
            this.logCallbackException("onEnd", e);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart();
        }
        catch (IOException e) {
            this.logCallbackException("onStart", e);
        }
        catch (RuntimeException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private void handleRuntimeException(RuntimeException e) {
        if (this.thrown == null) {
            this.thrown = e;
        } else {
            this.thrown.addSuppressed(e);
        }
    }

    private void logCallbackException(String callbackName, IOException e) {
        if (log.isDebugEnabled()) {
            log.warn("{}: Error handling {} callback", new Object[]{this.repository, callbackName, e});
        } else {
            log.warn("{}: Error handling {} callback: {}", new Object[]{this.repository, callbackName, e.getMessage()});
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

