/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetSupportZipRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamChunk;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSupportZipResponseObserver
extends AbstractFutureResponseObserver<RpcGetSupportZipRequest, RpcStreamChunk, Path> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");
    private static final Logger log = LoggerFactory.getLogger(GetSupportZipResponseObserver.class);
    private final MeshNode node;
    private final WritableByteChannel supportZipChannel;
    private final Path zipPath;

    public GetSupportZipResponseObserver(@Nonnull MeshNode node, @Nonnull ErrorTranslator errorTranslator, @Nonnull StorageService storageService) throws IOException {
        super(Objects.requireNonNull(errorTranslator, "errorTranslator"));
        this.node = Objects.requireNonNull(node, "node");
        String filename = String.format("Bitbucket-Mesh_%s_support_%s", node.getRpcId(), LocalDateTime.now().format(DATE_TIME_FORMATTER));
        this.zipPath = MoreFiles.mkdir((Path)Objects.requireNonNull(storageService, "storageService").getSharedHomeDir().resolve("export")).resolve(filename + ".zip");
        this.supportZipChannel = Files.newByteChannel(this.zipPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        this.addListener((result, thrown) -> {
            try {
                this.supportZipChannel.close();
            }
            catch (IOException e) {
                log.warn("Error while closing support zip output for node {}", (Object)node, (Object)e);
            }
            finally {
                if (thrown != null) {
                    MoreFiles.deleteQuietly((Path)this.zipPath);
                }
            }
        });
    }

    public void onNext(RpcStreamChunk value) {
        try {
            for (ByteBuffer byteBuffer : value.getData().asReadOnlyByteBufferList()) {
                this.supportZipChannel.write(byteBuffer);
            }
        }
        catch (IOException e) {
            log.warn("Failed to write support zip chunk to disk for node {}", (Object)this.node, (Object)e);
            this.requestStream.onError((Throwable)e);
        }
    }

    @Override
    public void onCompleted() {
        this.setResult(this.zipPath);
        super.onCompleted();
    }
}

