/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcCapabilityClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.MeshNodeIncompatibleException;
import com.atlassian.bitbucket.mesh.rpc.CapabilityServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.RpcApiCapability;
import com.atlassian.bitbucket.mesh.rpc.RpcCapability;
import com.atlassian.bitbucket.mesh.rpc.RpcGetCapabilitiesRequest;
import com.atlassian.bitbucket.mesh.rpc.RpcGetCapabilitiesResponse;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.ConnectivityErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshClient;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

@Profiled
public class GrpcCapabilityClient
extends AbstractGrpcClient<CapabilityServiceGrpc.CapabilityServiceStub>
implements RpcCapabilityClient {
    private static final Version REQUIRED_API_VERSION = new Version(new Integer[]{1, 9});
    private final MeshClient meshClient;

    public GrpcCapabilityClient(I18nService i18nService, MeshClient meshClient, GitRequestHelper requestHelper, MeshStub<CapabilityServiceGrpc.CapabilityServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.meshClient = meshClient;
    }

    public void verifyConnectivityAndCompatibility(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        ConnectivityErrorTranslator errorTranslator = new ConnectivityErrorTranslator(this.i18nService, node.getRpcUrl());
        ManagedChannel channel = null;
        try {
            channel = this.meshClient.openChannel(node);
            RpcGetCapabilitiesRequest request = RpcGetCapabilitiesRequest.getDefaultInstance();
            UnaryResponseObserver observer = new UnaryResponseObserver(errorTranslator);
            this.requestHelper.applyTimeout(CapabilityServiceGrpc.newStub((Channel)channel), (MessageOrBuilder)request, null).getCapabilities(request, observer);
            RpcGetCapabilitiesResponse response = (RpcGetCapabilitiesResponse)observer.asResult();
            this.checkCompatible(node, response.getCapabilitiesList());
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw errorTranslator.translate(e);
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    private static boolean isApiCompatible(RpcApiCapability capability) {
        Version minVersion = new Version(capability.getMinVersion());
        Version maxVersion = new Version(capability.getMaxVersion());
        return REQUIRED_API_VERSION.compareTo(minVersion) >= 0 && REQUIRED_API_VERSION.compareTo(maxVersion) <= 0;
    }

    private void checkCompatible(MeshNode node, List<RpcCapability> capabilities) {
        boolean apiCompatible = false;
        for (RpcCapability capability : capabilities) {
            switch (capability.getCapabilityOneofCase()) {
                case SUPPORTED_API_VERSIONS: {
                    apiCompatible |= GrpcCapabilityClient.isApiCompatible(capability.getSupportedApiVersions());
                }
            }
        }
        if (!apiCompatible) {
            throw new MeshNodeIncompatibleException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.incompatible", new Object[]{node.getRpcUrl(), REQUIRED_API_VERSION.toString()}), null);
        }
    }
}

