/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.LastModifiedCallback;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalRepositoryCommit;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.hook.repository.SimpleMergeHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.CommitServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcEditFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommonAncestorRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommonAncestorResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcLastModifiedRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRebaseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRebaseRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRebaseResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveCommitsResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolvedCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevertFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevertRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevertResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRunMergeHooks;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRunRebaseHooks;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTraverseCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTryMergeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRef;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryRef;
import com.atlassian.bitbucket.repository.SimpleRepositoryRef;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.git.command.rebase.GitRebaseException;
import com.atlassian.bitbucket.scm.git.command.revert.GitRevertException;
import com.atlassian.bitbucket.scm.signed.SigningFailedException;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.PreUpdateInvoker;
import com.atlassian.stash.internal.scm.git.merge.GitMergeStrategy;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.CommitsResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.CommonAncestorErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.ConversationalResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.EditFileResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.LastModifiedResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.MergeErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RebaseErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RequestMessageCreator;
import com.atlassian.stash.internal.scm.git.mesh.RevertErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcCommitClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.StreamingGetCommitsObserver;
import com.atlassian.stash.internal.scm.git.mesh.TraverseCommitsResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.atlassian.stash.internal.scm.git.rebase.SimpleGitRebaseHookRequest;
import com.google.common.base.MoreObjects;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Profiled
public class GrpcCommitClient
extends AbstractGrpcClient<CommitServiceGrpc.CommitServiceStub>
implements RpcCommitClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcCommitClient.class);
    private final Duration deadlinePaddingForHooks;
    private final RepositoryHookService hookService;
    private final int maxFragmentSize;

    public GrpcCommitClient(RepositoryHookService hookService, I18nService i18nService, GitRequestHelper requestHelper, Duration deadlinePaddingForHooks, int maxFragmentSize, MeshStub<CommitServiceGrpc.CommitServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.deadlinePaddingForHooks = deadlinePaddingForHooks;
        this.hookService = hookService;
        this.maxFragmentSize = maxFragmentSize;
    }

    @Override
    @Nonnull
    public Commit editFile(@Nonnull Repository repository, @Nonnull RpcEditFileRequest.Builder requestBuilder, @Nonnull InputSupplier<InputStream> content) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(content, "content");
        RpcEditFileRequest request = this.prepareBuilder(repository, requestBuilder).build();
        Duration deadline = GrpcCommitClient.calculateDeadline(request.getTimeouts(), 0.25, this.deadlinePaddingForHooks);
        CommitServiceGrpc.CommitServiceStub stub = (CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder, deadline);
        EditFileResponseObserver observer = new EditFileResponseObserver(this.hookService, this.i18nService, repository, request, this.requestHelper, this.getTargetNode(stub), content);
        stub.editFile((StreamObserver)observer);
        try {
            return observer.asResult();
        }
        catch (SigningFailedException e) {
            log.error("Failed to edit the file due to an issue with signing the commit", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Commit getCommit(@Nonnull Repository repository, @Nonnull RpcGetCommitRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcGetCommitRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getCommit(request, observer);
        RpcGetCommitResponse response = (RpcGetCommitResponse)observer.asResult();
        if (response.hasCommit()) {
            return RpcUtils.toCommit(response.getCommit(), repository);
        }
        return null;
    }

    @Override
    public void getCommits(@Nonnull Repository repository, @Nonnull RpcGetCommitsRequest.Builder requestBuilder, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RpcGetCommitsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        CommitsResponseObserver observer = new CommitsResponseObserver(callback, this.i18nService, repository, request.getAlternatesCount() > 0);
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getCommits(request, observer);
        observer.asResult();
    }

    @Override
    public MinimalCommit getCommonAncestor(@Nonnull Repository repository, @Nonnull RpcGetCommonAncestorRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        List commitIds = ByteStringUtils.toStrings((List)requestBuilder.getCommitishesList());
        if (commitIds.isEmpty()) {
            return null;
        }
        if (commitIds.size() == 1) {
            return new SimpleMinimalRepositoryCommit.Builder((String)commitIds.get(0)).repository(repository).build();
        }
        UnaryResponseObserver observer = new UnaryResponseObserver(new CommonAncestorErrorTranslator(this.i18nService, repository, commitIds));
        RpcGetCommonAncestorRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getCommonAncestor(request, observer);
        String commitId = ((RpcGetCommonAncestorResponse)observer.asResult()).getCommitId();
        if (StringUtils.isEmpty((CharSequence)commitId)) {
            return null;
        }
        return new SimpleMinimalRepositoryCommit.Builder(commitId).repository(repository).build();
    }

    @Override
    public void lastModified(@Nonnull Repository repository, @Nonnull RpcLastModifiedRequest.Builder requestBuilder, @Nonnull LastModifiedCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RpcLastModifiedRequest request = this.prepareBuilder(repository, requestBuilder).build();
        LastModifiedResponseObserver observer = new LastModifiedResponseObserver(callback, this.i18nService, repository, request);
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).lastModified(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    @Nonnull
    public Branch merge(@Nonnull Repository repository, Repository fromRepository, @Nonnull RpcMergeRequest.Builder requestBuilder, String strategyId) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        if (fromRepository != null) {
            requestBuilder.setFromRepository(this.requestHelper.toRepositoryId(fromRepository));
        }
        requestBuilder.setStrategy(this.toMergeStrategy(strategyId).toRpc());
        RpcMergeRequest request = this.prepareBuilder(repository, requestBuilder).build();
        return this.doMerge(repository, fromRepository, request, strategyId);
    }

    @Override
    @Nonnull
    public Branch rebase(@Nonnull Repository repository, Repository upstreamRepository, @Nonnull RpcRebaseRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        if (upstreamRepository != null) {
            requestBuilder.setUpstreamRepository(this.requestHelper.toRepositoryId(upstreamRepository));
        }
        RpcRebaseRequest request = this.prepareBuilder(repository, requestBuilder).build();
        return this.doRebase(repository, upstreamRepository, request);
    }

    @Override
    @Nonnull
    public Map<String, String> resolveCommits(@Nonnull Repository repository, @Nonnull RpcResolveCommitsRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcResolveCommitsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((CommitServiceGrpc.CommitServiceStub)this.stub.forRepository(repository)).resolveCommits(request, observer);
        List resolvedCommits = ((RpcResolveCommitsResponse)observer.asResult()).getResolvedCommitsList();
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>(resolvedCommits.size(), 1.0f);
        for (RpcResolvedCommit resolvedCommit : resolvedCommits) {
            results.put(resolvedCommit.getCommitish().toStringUtf8(), resolvedCommit.getCommitId());
        }
        return Collections.unmodifiableMap(results);
    }

    @Override
    @Nonnull
    public Branch revert(@Nonnull Repository repository, @Nonnull RpcRevertRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcRevertRequest request = this.prepareBuilder(repository, requestBuilder).build();
        return this.doRevert(repository, request);
    }

    @Override
    public CompletableFuture<Void> streamingGetCommits(@Nonnull Repository repository, @Nonnull RpcGetCommitsRequest.Builder requestBuilder, @Nonnull Iterator<String> includes, @Nonnull Iterator<String> excludes, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(includes, "includes");
        Objects.requireNonNull(excludes, "excludes");
        Objects.requireNonNull(callback, "callback");
        RpcGetCommitsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        StreamingGetCommitsObserver observer = new StreamingGetCommitsObserver(callback, this.i18nService, repository, request, includes, excludes, this.maxFragmentSize);
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).streamingGetCommits((StreamObserver)observer);
        return observer.asFuture();
    }

    @Override
    public void traverse(@Nonnull Repository repository, @Nonnull RpcTraverseCommitsRequest.Builder requestBuilder, @Nonnull TraversalCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RpcTraverseCommitsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        TraverseCommitsResponseObserver observer = new TraverseCommitsResponseObserver(callback, this.i18nService, repository);
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).traverseCommits(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void tryMerge(@Nonnull Repository repository, Repository fromRepository, @Nonnull RpcMergeRequest.Builder requestBuilder, String strategyId) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        if (fromRepository != null) {
            requestBuilder.setFromRepository(this.requestHelper.toRepositoryId(fromRepository));
        }
        requestBuilder.setStrategy(this.toMergeStrategy(strategyId).toRpc());
        RpcMergeRequest request = this.prepareBuilder(repository, requestBuilder).build();
        MergeErrorTranslator errorTranslator = new MergeErrorTranslator(this.i18nService, repository, fromRepository, request);
        UnaryResponseObserver observer = new UnaryResponseObserver(errorTranslator);
        Duration deadline = GrpcCommitClient.calculateDeadline(request.getTimeouts(), 0.25, null);
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, deadline)).tryMerge(request, observer);
        try {
            RpcTryMergeResponse response = (RpcTryMergeResponse)observer.asResult();
            if (response.hasConflicts()) {
                throw errorTranslator.translateMergeConflicts(response.getConflicts());
            }
        }
        catch (SigningFailedException e) {
            log.error("Failed to merge due to an issue with signing the merge commit", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void tryRebase(@Nonnull Repository repository, Repository upstreamRepository, @Nonnull RpcRebaseRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        if (upstreamRepository != null) {
            requestBuilder.setUpstreamRepository(this.requestHelper.toRepositoryId(upstreamRepository));
        }
        RpcRebaseRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new RebaseErrorTranslator(this.i18nService, repository, request));
        Duration deadline = GrpcCommitClient.calculateDeadline(request.getTimeouts(), 0.25, null);
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, deadline)).tryRebase(request, observer);
        observer.asResult();
    }

    private Branch doMerge(final Repository repository, final Repository fromRepository, final RpcMergeRequest request, final String strategyId) {
        MergeErrorTranslator errorTranslator = new MergeErrorTranslator(this.i18nService, repository, fromRepository, request);
        Duration deadline = GrpcCommitClient.calculateDeadline(request.getTimeouts(), 0.25, this.deadlinePaddingForHooks);
        final CommitServiceGrpc.CommitServiceStub stub = (CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, deadline);
        ConversationalResponseObserver<RpcMergeFragment, RpcMergeResponseFragment> responseObserver = new ConversationalResponseObserver<RpcMergeFragment, RpcMergeResponseFragment>(errorTranslator, new RequestMessageCreator<RpcMergeFragment, RpcMergeResponseFragment>(){
            private boolean more = true;

            @Override
            @Nonnull
            public RpcMergeFragment getFirst() {
                return RpcMergeFragment.newBuilder().setMergeRequest(request).build();
            }

            @Override
            public RpcMergeFragment getNext(@Nonnull RpcMergeResponseFragment response) {
                switch (Objects.requireNonNull(response, "response").getResponseOneofCase()) {
                    case MERGE_RESPONSE: {
                        return null;
                    }
                    case RUN_MERGE_HOOKS: {
                        this.more = false;
                        RpcRunMergeHooks hookRequest = response.getRunMergeHooks();
                        return GrpcCommitClient.this.requestHelper.withQuarantine(repository, GrpcCommitClient.this.getTargetNode(stub), hookRequest.getRepository(), () -> {
                            MergeHookInvoker preUpdateInvoker = new MergeHookInvoker(repository, fromRepository, request.getMessage().toStringUtf8(), strategyId, hookRequest);
                            preUpdateInvoker.callPreUpdate(hookRequest.getMergeCommit());
                            return RpcMergeFragment.newBuilder().setUpdateRef(RpcUpdateRef.getDefaultInstance()).build();
                        });
                    }
                }
                throw Status.INVALID_ARGUMENT.withDescription("Received [" + String.valueOf(response.getResponseOneofCase()) + "] where [" + String.valueOf(RpcMergeResponseFragment.ResponseOneofCase.RUN_MERGE_HOOKS) + "] was expected").asRuntimeException();
            }

            @Override
            public boolean hasMore() {
                return this.more;
            }
        });
        stub.merge(responseObserver);
        try {
            RpcMergeResponseFragment response = responseObserver.asResult();
            if (response.hasMergeResponse()) {
                RpcMergeResponse mergeResponse = response.getMergeResponse();
                switch (mergeResponse.getResponseOneofCase()) {
                    case BRANCH: {
                        return RpcUtils.toBranch(mergeResponse.getBranch());
                    }
                    case CONFLICTS: {
                        throw errorTranslator.translateMergeConflicts(mergeResponse.getConflicts());
                    }
                }
            }
        }
        catch (SigningFailedException e) {
            log.error("Failed to merge due to an issue with signing the merge commit", (Throwable)e);
            throw e;
        }
        String fromBranch = request.getFromBranch().toStringUtf8();
        String toBranch = request.getToBranch().toStringUtf8();
        KeyedMessage message = Objects.equals(repository, fromRepository) ? this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.intrarepository", new Object[]{repository.getProject().getKey(), repository.getSlug(), fromBranch, request.getFromCommitId(), toBranch}) : this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.interrepository", new Object[]{fromRepository.getProject().getKey(), fromRepository.getSlug(), repository.getProject().getKey(), repository.getSlug(), fromBranch, request.getFromCommitId(), toBranch});
        throw new MergeException(message, "git", repository, fromBranch, toBranch, false);
    }

    private Branch doRebase(final Repository repository, final Repository upstreamRepository, final RpcRebaseRequest request) {
        Duration deadline = GrpcCommitClient.calculateDeadline(request.getTimeouts(), 0.25, this.deadlinePaddingForHooks);
        final CommitServiceGrpc.CommitServiceStub stub = (CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, deadline);
        ConversationalResponseObserver<RpcRebaseFragment, RpcRebaseResponseFragment> responseObserver = new ConversationalResponseObserver<RpcRebaseFragment, RpcRebaseResponseFragment>(new RebaseErrorTranslator(this.i18nService, repository, request), new RequestMessageCreator<RpcRebaseFragment, RpcRebaseResponseFragment>(){
            private boolean more = true;

            @Override
            @Nonnull
            public RpcRebaseFragment getFirst() {
                return RpcRebaseFragment.newBuilder().setRebaseRequest(request).build();
            }

            @Override
            public RpcRebaseFragment getNext(@Nonnull RpcRebaseResponseFragment response) {
                Objects.requireNonNull(response, "response");
                if (response.getResponseOneofCase() != RpcRebaseResponseFragment.ResponseOneofCase.RUN_REBASE_HOOKS) {
                    throw Status.INVALID_ARGUMENT.withDescription("Received [" + String.valueOf(response.getResponseOneofCase()) + "] where [" + String.valueOf(RpcRebaseResponseFragment.ResponseOneofCase.RUN_REBASE_HOOKS) + "] was expected").asRuntimeException();
                }
                this.more = false;
                RpcRunRebaseHooks hookRequest = response.getRunRebaseHooks();
                return GrpcCommitClient.this.requestHelper.withQuarantine(repository, GrpcCommitClient.this.getTargetNode(stub), hookRequest.getRepository(), () -> {
                    RebaseHookInvoker preUpdateInvoker = new RebaseHookInvoker(repository, upstreamRepository, RpcUtils.toBranch(hookRequest.getBranch()), request.getUpstream().toStringUtf8());
                    preUpdateInvoker.callPreUpdate(hookRequest.getCommitId());
                    return RpcRebaseFragment.newBuilder().setUpdateRef(RpcUpdateRef.getDefaultInstance()).build();
                });
            }

            @Override
            public boolean hasMore() {
                return this.more;
            }
        });
        stub.rebase(responseObserver);
        RpcRebaseResponseFragment response = responseObserver.asResult();
        if (!response.hasRebaseResponse() || !response.getRebaseResponse().hasBranch()) {
            throw new GitRebaseException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.failed", new Object[0]));
        }
        return RpcUtils.toBranch(response.getRebaseResponse().getBranch());
    }

    private Branch doRevert(Repository repository, final RpcRevertRequest request) {
        RevertErrorTranslator errorTranslator = new RevertErrorTranslator(this.i18nService, repository, request);
        ConversationalResponseObserver<RpcRevertFragment, RpcRevertResponseFragment> responseObserver = new ConversationalResponseObserver<RpcRevertFragment, RpcRevertResponseFragment>(errorTranslator, new RequestMessageCreator<RpcRevertFragment, RpcRevertResponseFragment>(){
            private boolean more = true;

            @Override
            @Nonnull
            public RpcRevertFragment getFirst() {
                return RpcRevertFragment.newBuilder().setRevertRequest(request).build();
            }

            @Override
            public RpcRevertFragment getNext(@Nonnull RpcRevertResponseFragment response) {
                switch (Objects.requireNonNull(response, "response").getResponseOneofCase()) {
                    case REVERT_RESPONSE: {
                        return null;
                    }
                    case RUN_REVERT_HOOKS: {
                        this.more = false;
                        return RpcRevertFragment.newBuilder().setUpdateRef(RpcUpdateRef.getDefaultInstance()).build();
                    }
                }
                throw Status.INVALID_ARGUMENT.withDescription("Received [" + String.valueOf(response.getResponseOneofCase()) + "] where [" + String.valueOf(RpcRevertResponseFragment.ResponseOneofCase.RUN_REVERT_HOOKS) + "] was expected").asRuntimeException();
            }

            @Override
            public boolean hasMore() {
                return this.more;
            }
        });
        Duration deadline = GrpcCommitClient.calculateDeadline(request.getTimeouts(), 0.25, this.deadlinePaddingForHooks);
        ((CommitServiceGrpc.CommitServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, deadline)).revert(responseObserver);
        RpcRevertResponseFragment response = responseObserver.asResult();
        if (!response.hasRevertResponse() || !response.getRevertResponse().hasBranch()) {
            throw new GitRevertException(this.i18nService.createKeyedMessage("bitbucket.git.revert.commandfailed", new Object[]{request.getCommitId(), repository}));
        }
        return RpcUtils.toBranch(response.getRevertResponse().getBranch());
    }

    private GitMergeStrategy toMergeStrategy(String strategyId) {
        if (StringUtils.isBlank((CharSequence)strategyId)) {
            return GitMergeStrategy.NO_FF;
        }
        return GitMergeStrategy.fromId(strategyId).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.merge.unsupportedstrategy", new Object[]{strategyId, Arrays.stream(GitMergeStrategy.values()).map(GitMergeStrategy::getId).collect(Collectors.toList())})));
    }

    private class RebaseHookInvoker
    implements PreUpdateInvoker {
        private final Branch branch;
        private final Repository repository;
        private final String upstream;
        private final Repository upstreamRepository;

        private RebaseHookInvoker(Repository repository, Repository upstreamRepository, Branch branch, String upstream) {
            this.branch = branch;
            this.repository = repository;
            this.upstream = upstream;
            this.upstreamRepository = upstreamRepository;
        }

        @Override
        public void callPreUpdate(@Nonnull String commitId) {
            SimpleGitRebaseHookRequest hookRequest = ((SimpleGitRebaseHookRequest.Builder)new SimpleGitRebaseHookRequest.Builder(this.repository).branch(this.branch).commitId(commitId).dryRun(false)).upstream(this.upstream).upstreamRepository(this.upstreamRepository).build();
            RepositoryHookResult result = GrpcCommitClient.this.hookService.preUpdate((RepositoryHookRequest)hookRequest);
            if (result.isRejected()) {
                throw new RepositoryHookVetoedException(GrpcCommitClient.this.i18nService.createKeyedMessage("bitbucket.git.rebase.canceled", new Object[]{this.branch.getDisplayId()}), (RepositoryHookRequest)hookRequest, result.getVetoes());
            }
        }
    }

    private class MergeHookInvoker
    implements PreUpdateInvoker {
        private final Ref fromRef;
        private final Repository fromRepository;
        private final String message;
        private final Repository repository;
        private final String strategyId;
        private final Ref toRef;

        private MergeHookInvoker(Repository repository, Repository fromRepository, String message, String strategyId, RpcRunMergeHooks hookRequest) {
            this.fromRepository = (Repository)MoreObjects.firstNonNull((Object)fromRepository, (Object)repository);
            this.message = message;
            this.repository = repository;
            this.strategyId = strategyId;
            this.fromRef = RpcUtils.toBranch(hookRequest.getFromRef());
            this.toRef = RpcUtils.toBranch(hookRequest.getToRef());
        }

        @Override
        public void callPreUpdate(@Nonnull String mergeHash) {
            SimpleMergeHookRequest hookRequest = ((SimpleMergeHookRequest.Builder)new SimpleMergeHookRequest.Builder(this.repository).dryRun(false)).fromRef((RepositoryRef)new SimpleRepositoryRef.Builder(this.fromRepository, this.fromRef).build()).mergeHash(mergeHash).message(this.message).strategyId(this.strategyId).toRef((RepositoryRef)new SimpleRepositoryRef.Builder(this.repository, this.toRef).build()).build();
            RepositoryHookResult result = GrpcCommitClient.this.hookService.preUpdate((RepositoryHookRequest)hookRequest);
            if (result.isRejected()) {
                throw new RepositoryHookVetoedException(GrpcCommitClient.this.i18nService.createKeyedMessage("bitbucket.git.merge.canceled", new Object[]{hookRequest.getToRef().getDisplayId()}), (RepositoryHookRequest)hookRequest, result.getVetoes());
            }
        }
    }
}

