/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.ContentServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlameStreamRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetNodeTypeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetNodeTypeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetObjectInfoRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetObjectInfoResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcListDirectoryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.GitObjectInfo;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.BlameResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.ListDirectoryResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RpcContentClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.atlassian.stash.internal.scm.git.submodule.SubmoduleUrlBuilder;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@Profiled
public class GrpcContentClient
extends AbstractGrpcClient<ContentServiceGrpc.ContentServiceStub>
implements RpcContentClient {
    private final SubmoduleUrlBuilder urlBuilder;

    public GrpcContentClient(I18nService i18nService, GitRequestHelper requestHelper, SubmoduleUrlBuilder urlBuilder, MeshStub<ContentServiceGrpc.ContentServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.urlBuilder = urlBuilder;
    }

    @Override
    public void blame(@Nonnull Repository repository, @Nonnull RpcBlameStreamRequest.Builder requestBuilder, @Nonnull FileContext fileContext, @Nonnull FileContentCallback callback, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        BlameResponseObserver observer = new BlameResponseObserver(callback, fileContext, this.i18nService, pageRequest, repository);
        RpcBlameStreamRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((ContentServiceGrpc.ContentServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).blame(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    @Nonnull
    public ContentTreeNode.Type getNodeType(@Nonnull Repository repository, @Nonnull RpcGetNodeTypeRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcGetNodeTypeRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((ContentServiceGrpc.ContentServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getNodeType(request, observer);
        return RpcUtils.toNodeType(((RpcGetNodeTypeResponse)observer.asResult()).getType());
    }

    @Override
    @Nonnull
    public GitObjectInfo getObjectInfo(@Nonnull Repository repository, @Nonnull RpcGetObjectInfoRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcGetObjectInfoRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((ContentServiceGrpc.ContentServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getObjectInfo(request, observer);
        return RpcUtils.toObjectInfo(((RpcGetObjectInfoResponse)observer.asResult()).getObjectInfo());
    }

    @Override
    public void listDirectory(@Nonnull Repository repository, @Nonnull RpcListDirectoryRequest.Builder requestBuilder, @Nonnull ContentTreeCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RpcListDirectoryRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ListDirectoryResponseObserver observer = new ListDirectoryResponseObserver(callback, this.i18nService, this.urlBuilder, repository, request);
        ((ContentServiceGrpc.ContentServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).listDirectory(request, (StreamObserver)observer);
        observer.asResult();
    }
}

