/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.GitDataServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadPackFileRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RpcDataClient;
import com.atlassian.stash.internal.scm.git.mesh.UploadPackFileParameters;
import com.atlassian.stash.internal.scm.git.mesh.UploadPackFileResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.UploadSummary;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@Profiled
public class GrpcDataClient
extends AbstractGrpcClient<GitDataServiceGrpc.GitDataServiceStub>
implements RpcDataClient {
    private final GitCommandBuilderFactory builderFactory;
    private int uploadFilesBatchSize;

    public GrpcDataClient(GitCommandBuilderFactory builderFactory, I18nService i18nService, GitRequestHelper requestHelper, MeshStub<GitDataServiceGrpc.GitDataServiceStub> stub, int uploadFilesBatchSize) {
        super(i18nService, requestHelper, stub);
        this.builderFactory = builderFactory;
        this.uploadFilesBatchSize = Math.max(10, uploadFilesBatchSize);
    }

    @Override
    @Nonnull
    public UploadSummary uploadPackFile(@Nonnull MeshNode node, @Nonnull Repository repository, @Nonnull UploadPackFileParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(repository, "repository");
        RpcUploadPackFileRequest request = this.requestHelper.prepareBuilder(repository, RpcUploadPackFileRequest.newBuilder().setTimeouts(RpcGitTimeouts.newBuilder().setExecution(parameters.getTimeout().getSeconds()).setIdle(parameters.getTimeout().getSeconds()))).build();
        UploadPackFileResponseObserver responseObserver = new UploadPackFileResponseObserver(this.builderFactory, this.i18nService, parameters, repository, request);
        this.requestHelper.applyTimeout((GitDataServiceGrpc.GitDataServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).uploadPackFile((StreamObserver)responseObserver);
        return responseObserver.asResult();
    }

    @VisibleForTesting
    int setUploadFilesBatchSize(int size) {
        int oldValue = this.uploadFilesBatchSize;
        this.uploadFilesBatchSize = size;
        return oldValue;
    }
}

