/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.DiffServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChangesetPageRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStreamRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffTreePageRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.SatiableConsumer;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.ChangesResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ChangesetResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DiffResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RpcDiffClient;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@Profiled
public class GrpcDiffClient
extends AbstractGrpcClient<DiffServiceGrpc.DiffServiceStub>
implements RpcDiffClient {
    public GrpcDiffClient(I18nService i18nService, GitRequestHelper requestHelper, MeshStub<DiffServiceGrpc.DiffServiceStub> stub) {
        super(i18nService, requestHelper, stub);
    }

    @Override
    public void changesets(@Nonnull Repository repository, @Nonnull RpcChangesetPageRequest.Builder requestBuilder, @Nonnull SatiableConsumer<Changeset> callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        PageRequest changesPageRequest = PageUtils.newRequest((int)0, (int)requestBuilder.getMaxChangesPerCommit());
        ChangesetResponseObserver observer = new ChangesetResponseObserver(callback, this.i18nService, repository, changesPageRequest);
        RpcChangesetPageRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((DiffServiceGrpc.DiffServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).changesets(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void diff(@Nonnull Repository repository, @Nonnull RpcDiffStreamRequest.Builder requestBuilder, @Nonnull DiffContentCallback callback, @Nonnull DiffContext diffContext) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(diffContext, "changeContext");
        DiffResponseObserver observer = new DiffResponseObserver(callback, diffContext, this.i18nService, repository);
        RpcDiffStreamRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((DiffServiceGrpc.DiffServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).diff(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void diffTree(@Nonnull Repository repository, @Nonnull RpcDiffTreePageRequest.Builder requestBuilder, @Nonnull ChangeCallback callback, @Nonnull ChangeContext changeContext) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(changeContext, "changeContext");
        ChangesResponseObserver observer = new ChangesResponseObserver(callback, changeContext, this.i18nService, repository);
        RpcDiffTreePageRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((DiffServiceGrpc.DiffServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).diffTree(request, (StreamObserver)observer);
        observer.asResult();
    }
}

