/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.IoSupplier;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCloseWorkTreeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateWorkTreeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateWorkTreeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublishWorkTreeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWorkTreeMkdirRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWriteWorkTreeFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.WorkTreeServiceGrpc;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.worktree.PublishGitWorkTreeParameters;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.scm.git.command.GitWorkTreeCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.PublishWorkTreeResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.RpcGitWorkTreeClient;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.WorkTreeErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.WorkTreeWriteFileResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.worktree.MeshGitWorkTree;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Objects;

public class GrpcGitWorkTreeClient
extends AbstractGrpcClient<WorkTreeServiceGrpc.WorkTreeServiceStub>
implements RpcGitWorkTreeClient {
    private final GitWorkTreeCommandBuilderFactory builderFactory;
    private final HomeLayout homeLayout;

    public GrpcGitWorkTreeClient(I18nService i18nService, GitRequestHelper requestHelper, GitWorkTreeCommandBuilderFactory builderFactory, HomeLayout homeLayout, MeshStub<WorkTreeServiceGrpc.WorkTreeServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.builderFactory = builderFactory;
        this.homeLayout = homeLayout;
    }

    @Override
    public void close(@Nonnull MeshGitWorkTree workTree, @Nonnull RpcCloseWorkTreeRequest.Builder requestBuilder) {
        Objects.requireNonNull(workTree, "workTree");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new WorkTreeErrorTranslator(this.i18nService, workTree.getRepository()));
        RpcCloseWorkTreeRequest request = this.prepareBuilder(workTree, requestBuilder).build();
        ((WorkTreeServiceGrpc.WorkTreeServiceStub)this.getStubWithDeadline(workTree, (MessageOrBuilder)request)).close(request, observer);
        observer.asResult();
    }

    @Override
    public MeshGitWorkTree create(@Nonnull Repository repository, @Nonnull RpcCreateWorkTreeRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new WorkTreeErrorTranslator(this.i18nService, repository));
        RpcCreateWorkTreeRequest request = this.prepareBuilder(repository, requestBuilder).build();
        WorkTreeServiceGrpc.WorkTreeServiceStub stub = (WorkTreeServiceGrpc.WorkTreeServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request);
        stub.create(request, observer);
        RpcCreateWorkTreeResponse response = (RpcCreateWorkTreeResponse)observer.asResult();
        return new MeshGitWorkTree(this.builderFactory, Instant.ofEpochMilli(response.getExpiry()), !requestBuilder.getAlternatesList().isEmpty(), repository, this.getTargetNode(stub), this.homeLayout.getTempDir(), this, response.getWorkTree());
    }

    @Override
    public void mkdir(@Nonnull MeshGitWorkTree workTree, @Nonnull RpcWorkTreeMkdirRequest.Builder requestBuilder) throws IOException {
        Objects.requireNonNull(workTree, "workTree");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new WorkTreeErrorTranslator(this.i18nService, workTree.getRepository()));
        RpcWorkTreeMkdirRequest request = this.prepareBuilder(workTree, requestBuilder).build();
        ((WorkTreeServiceGrpc.WorkTreeServiceStub)this.getStubWithDeadline(workTree, (MessageOrBuilder)request)).mkdir(request, observer);
        observer.asResult(IOException.class);
    }

    @Override
    public void publish(@Nonnull MeshGitWorkTree workTree, @Nonnull RpcPublishWorkTreeRequest.Builder requestBuilder, @Nonnull PublishGitWorkTreeParameters parameters) {
        Objects.requireNonNull(workTree, "workTree");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(parameters, "parameters");
        RpcPublishWorkTreeRequest request = this.prepareBuilder(workTree, requestBuilder).build();
        PublishWorkTreeResponseObserver responseObserver = new PublishWorkTreeResponseObserver(new WorkTreeErrorTranslator(this.i18nService, workTree.getRepository()), workTree, this.requestHelper, request, parameters);
        ((WorkTreeServiceGrpc.WorkTreeServiceStub)this.getStubWithDeadline(workTree, (MessageOrBuilder)request)).publish((StreamObserver)responseObserver);
        responseObserver.asResult();
    }

    @Override
    public void write(@Nonnull MeshGitWorkTree workTree, @Nonnull RpcWriteWorkTreeFileRequest.Builder requestBuilder, @Nonnull IoSupplier<InputStream> dataProvider) throws IOException {
        Objects.requireNonNull(workTree, "workTree");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(dataProvider, "dataProvider");
        RpcWriteWorkTreeFileRequest request = this.prepareBuilder(workTree, requestBuilder).build();
        try (InputStream in = Objects.requireNonNull((InputStream)dataProvider.get(), "inputStream");){
            WorkTreeWriteFileResponseObserver responseObserver = new WorkTreeWriteFileResponseObserver(request, in, new WorkTreeErrorTranslator(this.i18nService, workTree.getRepository()));
            ((WorkTreeServiceGrpc.WorkTreeServiceStub)this.getStubWithDeadline(workTree, (MessageOrBuilder)request)).writeFile((StreamObserver)responseObserver);
            responseObserver.asResult(IOException.class);
        }
    }
}

