/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.script.HookScriptStoreException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.HookScriptCallback;
import com.atlassian.bitbucket.internal.mesh.HookScriptOutcome;
import com.atlassian.bitbucket.internal.mesh.RpcHookScriptClient;
import com.atlassian.bitbucket.mesh.rpc.v1.HookScriptServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCallHookScriptsFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCallHookScriptsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCallHookScriptsResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookResult;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookScript;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookScriptChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookScriptResponse;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Profiled
public class GrpcHookScriptClient
extends AbstractGrpcClient<HookScriptServiceGrpc.HookScriptServiceStub>
implements RpcHookScriptClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcHookScriptClient.class);

    public GrpcHookScriptClient(I18nService i18nService, GitRequestHelper requestHelper, MeshStub<HookScriptServiceGrpc.HookScriptServiceStub> stub) {
        super(i18nService, requestHelper, stub);
    }

    public void callHookScripts(@Nonnull Repository repository, @Nonnull RpcCallHookScriptsRequest.Builder requestBuilder, ScmHookDetails scmHookDetails, @Nonnull HookScriptCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        if (requestBuilder.getHookScriptList().isEmpty()) {
            return;
        }
        RpcCallHookScriptsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        CallHookScriptsObserver observer = new CallHookScriptsObserver(callback, new DefaultErrorTranslator(this.i18nService, repository), repository, request, scmHookDetails);
        Duration timeout = Duration.ofSeconds(request.getHookScriptOptions().getTimeouts().getExecution() * (long)request.getHookScriptCount());
        ((HookScriptServiceGrpc.HookScriptServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, timeout)).callHookScripts((StreamObserver)observer);
        observer.asResult();
    }

    private static class CallHookScriptsObserver
    extends AbstractFutureResponseObserver<RpcCallHookScriptsFragment, RpcCallHookScriptsResponseFragment, Void> {
        private final Map<String, StringBuilder> bufferedScriptOutput;
        private final HookScriptCallback callback;
        private final AtomicBoolean completed;
        private final RpcCallHookScriptsRequest request;
        private final Repository repository;
        private final ScmHookDetails scmHookDetails;

        CallHookScriptsObserver(HookScriptCallback callback, ErrorTranslator errorTranslator, Repository repository, RpcCallHookScriptsRequest request, ScmHookDetails scmHookDetails) {
            super(errorTranslator);
            this.callback = callback;
            this.request = request;
            this.repository = repository;
            this.scmHookDetails = scmHookDetails;
            this.bufferedScriptOutput = new HashMap<String, StringBuilder>();
            this.completed = new AtomicBoolean(false);
        }

        @Override
        public void onCompleted() {
            this.maybeSendOnCompleted();
            super.onCompleted();
        }

        @Override
        public void onError(Throwable t) {
            Status.Code code = Status.fromThrowable((Throwable)t).getCode();
            if (code == Status.Code.CANCELLED && (t instanceof StatusRuntimeException || t instanceof StatusException)) {
                t = t.getCause();
            }
            if (t == null) {
                this.onCompleted();
            } else {
                super.onError(this.maybeTranslate(t));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(RpcCallHookScriptsResponseFragment value) {
            switch (value.getFragmentOneofCase()) {
                case CHUNK: {
                    RpcHookScriptChunk scriptChunk = value.getChunk();
                    RpcHookChunk chunk = scriptChunk.getChunk();
                    String chunkString = chunk.getData().toStringUtf8();
                    if (this.scmHookDetails == null) {
                        this.bufferedScriptOutput.computeIfAbsent(scriptChunk.getHookScript(), ignored -> new StringBuilder()).append(chunkString);
                        break;
                    }
                    if (chunk.getChannel() == RpcHookChunk.Channel.CHANNEL_STDERR) {
                        this.scmHookDetails.err().write(chunkString);
                        break;
                    }
                    this.scmHookDetails.out().write(chunkString);
                    break;
                }
                case MISSING: {
                    ProtocolStringList missing = value.getMissing().getHookScriptList();
                    log.info("Sending missing hook scripts {}", (Object)missing);
                    for (String hookScript : missing) {
                        this.sendMissingScript(hookScript);
                    }
                    break;
                }
                case RESPONSE: {
                    try {
                        HashSet unhandled = new HashSet(this.request.getHookScriptList());
                        for (RpcHookScriptResponse response : value.getResponse().getResponsesList()) {
                            log.trace("Hook script {}: {}", (Object)response.getHookScript(), (Object)response.getResult());
                            this.onResponse(response);
                            unhandled.remove(response.getHookScript());
                        }
                        for (String hookScript : unhandled) {
                            this.callback.onScriptResult(hookScript, HookScriptOutcome.NOT_CALLED, Duration.ZERO, null);
                        }
                        break;
                    }
                    finally {
                        this.setResult(null);
                    }
                }
            }
            this.maybeSendOnCompleted();
        }

        @Override
        Void asResult() {
            this.requestStream.onNext((Object)RpcCallHookScriptsFragment.newBuilder().setRequest(this.request).build());
            return (Void)super.asResult();
        }

        private void maybeSendOnCompleted() {
            if (this.completed.compareAndSet(false, true)) {
                this.requestStream.onCompleted();
            }
        }

        private void onResponse(RpcHookScriptResponse response) {
            String output = null;
            if (this.bufferedScriptOutput.containsKey(response.getHookScript())) {
                output = this.bufferedScriptOutput.get(response.getHookScript()).toString();
            }
            this.callback.onScriptResult(response.getHookScript(), this.toOutcome(response.getHookScript(), response.getResult()), Duration.ofMillis(response.getDurationMs()), output);
        }

        private void sendMissingScript(String hookScript) {
            try (InputStream inputStream = (InputStream)this.callback.onMissingScript(hookScript).open();){
                ByteString content = ByteString.readFrom((InputStream)inputStream);
                this.requestStream.onNext((Object)RpcCallHookScriptsFragment.newBuilder().setHookScript(RpcHookScript.newBuilder().setId(hookScript).setContent(content)).build());
            }
            catch (HookScriptStoreException | IOException e) {
                log.warn("[{}] Could not send hook script {} to git agent", new Object[]{this.repository, hookScript, e});
                this.callback.onScriptResult(hookScript, HookScriptOutcome.ERROR, Duration.ZERO, e.getMessage());
            }
        }

        private HookScriptOutcome toOutcome(String hookScript, @Nonnull RpcHookResult hookResult) {
            switch (hookResult) {
                case HOOK_RESULT_ACCEPTED: {
                    return HookScriptOutcome.ACCEPTED;
                }
                case HOOK_RESULT_NOT_CALLED: {
                    return HookScriptOutcome.NOT_CALLED;
                }
                case HOOK_RESULT_REJECTED: {
                    return HookScriptOutcome.REJECTED;
                }
            }
            log.warn("[{}]: Cannot determine whether hook script {} was called (result = {}).Assuming the script produced an error.", new Object[]{this.repository, hookScript, hookResult});
            return HookScriptOutcome.ERROR;
        }
    }
}

