/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.HostingServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingPostReceiveResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingPreReceiveResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHttpBackendFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHttpBackendRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReceivePackFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReceivePackRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadArchiveFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadArchiveRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadPackFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadPackRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.BidirectionalHostingReadFragmentResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.BidirectionalHostingWriteFragmentResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.HostingWriteRequestFragmentCreator;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RequestFragmentCreator;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.google.protobuf.MessageOrBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@Profiled
public class GrpcHostingClient
extends AbstractGrpcClient<HostingServiceGrpc.HostingServiceStub>
implements RpcHostingClient {
    private final InternalRepositoryHookService hookService;

    public GrpcHostingClient(I18nService i18nService, GitRequestHelper requestHelper, InternalRepositoryHookService hookService, MeshStub<HostingServiceGrpc.HostingServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.hookService = hookService;
    }

    @Override
    @Nonnull
    public HostingResult httpBackend(@Nonnull Repository repository, final @Nonnull RpcHttpBackendRequest.Builder requestBuilder, @Nonnull NioStdioHandler<Void> stdioHandler, @Nonnull CommandExitHandler exitHandler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(stdioHandler, "stdioHandler");
        Objects.requireNonNull(exitHandler, "exitHandler");
        this.prepareBuilder(repository, requestBuilder);
        HostingServiceGrpc.HostingServiceStub stub = (HostingServiceGrpc.HostingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder);
        BidirectionalHostingWriteFragmentResponseObserver<RpcHttpBackendFragment> responseObserver = new BidirectionalHostingWriteFragmentResponseObserver<RpcHttpBackendFragment>(stdioHandler, new DefaultErrorTranslator(this.i18nService, repository), exitHandler, repository, new HostingWriteRequestFragmentCreator<RpcHttpBackendFragment>(){

            @Override
            @Nonnull
            public RpcHttpBackendFragment forPostReceive(@Nonnull RpcHostingPostReceiveResponse postReceive) {
                return RpcHttpBackendFragment.newBuilder().setPostReceive(postReceive).build();
            }

            @Override
            @Nonnull
            public RpcHttpBackendFragment forPreReceive(@Nonnull RpcHostingPreReceiveResponse preReceive) {
                return RpcHttpBackendFragment.newBuilder().setPreReceive(preReceive).build();
            }

            @Override
            @Nonnull
            public RpcHttpBackendFragment forStdin(@Nonnull RpcStreamChunk stdin) {
                Objects.requireNonNull(stdin, "stdin");
                return RpcHttpBackendFragment.newBuilder().setStdin(stdin).build();
            }

            @Override
            @Nonnull
            public RpcHttpBackendFragment getInitial() {
                return RpcHttpBackendFragment.newBuilder().setRequest(requestBuilder).build();
            }
        }, this.hookService, this.i18nService, this.requestHelper, this.getTargetNode(stub));
        stub.httpBackend(responseObserver);
        return responseObserver.asResult();
    }

    @Override
    @Nonnull
    public HostingResult receivePack(@Nonnull Repository repository, final @Nonnull RpcReceivePackRequest.Builder requestBuilder, @Nonnull NioStdioHandler<Void> stdioHandler, @Nonnull CommandExitHandler exitHandler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(stdioHandler, "stdioHandler");
        Objects.requireNonNull(exitHandler, "exitHandler");
        this.prepareBuilder(repository, requestBuilder);
        HostingServiceGrpc.HostingServiceStub stub = (HostingServiceGrpc.HostingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder);
        BidirectionalHostingWriteFragmentResponseObserver<RpcReceivePackFragment> responseObserver = new BidirectionalHostingWriteFragmentResponseObserver<RpcReceivePackFragment>(stdioHandler, new DefaultErrorTranslator(this.i18nService, repository), exitHandler, repository, new HostingWriteRequestFragmentCreator<RpcReceivePackFragment>(){

            @Override
            @Nonnull
            public RpcReceivePackFragment forPostReceive(@Nonnull RpcHostingPostReceiveResponse postReceive) {
                return RpcReceivePackFragment.newBuilder().setPostReceive(postReceive).build();
            }

            @Override
            @Nonnull
            public RpcReceivePackFragment forPreReceive(@Nonnull RpcHostingPreReceiveResponse preReceive) {
                return RpcReceivePackFragment.newBuilder().setPreReceive(preReceive).build();
            }

            @Override
            @Nonnull
            public RpcReceivePackFragment forStdin(@Nonnull RpcStreamChunk stdin) {
                Objects.requireNonNull(stdin, "stdin");
                return RpcReceivePackFragment.newBuilder().setStdin(stdin).build();
            }

            @Override
            @Nonnull
            public RpcReceivePackFragment getInitial() {
                return RpcReceivePackFragment.newBuilder().setRequest(requestBuilder).build();
            }
        }, this.hookService, this.i18nService, this.requestHelper, this.getTargetNode(stub));
        stub.receivePack(responseObserver);
        return responseObserver.asResult();
    }

    @Override
    @Nonnull
    public HostingResult uploadArchive(@Nonnull Repository repository, final @Nonnull RpcUploadArchiveRequest.Builder requestBuilder, @Nonnull NioStdioHandler<Void> stdioHandler, @Nonnull CommandExitHandler exitHandler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(stdioHandler, "stdioHandler");
        Objects.requireNonNull(exitHandler, "exitHandler");
        this.prepareBuilder(repository, requestBuilder);
        BidirectionalHostingReadFragmentResponseObserver<RpcUploadArchiveFragment> responseObserver = new BidirectionalHostingReadFragmentResponseObserver<RpcUploadArchiveFragment>(stdioHandler, new DefaultErrorTranslator(this.i18nService, repository), exitHandler, new RequestFragmentCreator<RpcUploadArchiveFragment>(){

            @Override
            @Nonnull
            public RpcUploadArchiveFragment forStdin(@Nonnull RpcStreamChunk stdin) {
                Objects.requireNonNull(stdin, "stdin");
                return RpcUploadArchiveFragment.newBuilder().setStdin(stdin).build();
            }

            @Override
            @Nonnull
            public RpcUploadArchiveFragment getInitial() {
                return RpcUploadArchiveFragment.newBuilder().setRequest(requestBuilder).build();
            }
        }, this.i18nService);
        ((HostingServiceGrpc.HostingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder)).uploadArchive(responseObserver);
        return responseObserver.asResult();
    }

    @Override
    @Nonnull
    public HostingResult uploadPack(@Nonnull Repository repository, final @Nonnull RpcUploadPackRequest.Builder requestBuilder, @Nonnull NioStdioHandler<Void> stdioHandler, @Nonnull CommandExitHandler exitHandler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(stdioHandler, "stdioHandler");
        this.prepareBuilder(repository, requestBuilder);
        BidirectionalHostingReadFragmentResponseObserver<RpcUploadPackFragment> responseObserver = new BidirectionalHostingReadFragmentResponseObserver<RpcUploadPackFragment>(stdioHandler, new DefaultErrorTranslator(this.i18nService, repository), exitHandler, new RequestFragmentCreator<RpcUploadPackFragment>(){

            @Override
            @Nonnull
            public RpcUploadPackFragment forStdin(@Nonnull RpcStreamChunk stdin) {
                Objects.requireNonNull(stdin, "stdin");
                return RpcUploadPackFragment.newBuilder().setStdin(stdin).build();
            }

            @Override
            @Nonnull
            public RpcUploadPackFragment getInitial() {
                return RpcUploadPackFragment.newBuilder().setRequest(requestBuilder).build();
            }
        }, this.i18nService);
        ((HostingServiceGrpc.HostingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder)).uploadPack(responseObserver);
        return responseObserver.asResult();
    }
}

