/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.dmz.repository.RepositoryCallback;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.internal.mesh.support.SupportInfo;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.ManagementServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAddDataStoreRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAddDataStoreResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAllRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDrainRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetDataStoresRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetDataStoresResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetNodeInfoRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetNodeInfoResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetSupportInfoRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetSupportZipRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHeartbeat;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMarkRepositoriesInconsistentRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNodeIdList;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPartitionsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcProvisionNodeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcProvisionNodeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepairRepositoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepairRepositoryResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReplaceReadOnlyRepositoriesFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReplaceReadOnlyRepositoriesResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReplicaState;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResetHierarchyRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResetHierarchyResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetConfigurationRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetReplicaStateRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetRepositoryReadOnlyRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.mesh.RemoteDataStore;
import com.atlassian.stash.internal.scm.git.GitRepositorySupplier;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.ConnectivityErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DrainResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GetSupportZipResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshClient;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.SigningErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Path;
import java.security.PublicKey;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Profiled
public class GrpcManagementClient
extends AbstractGrpcClient<ManagementServiceGrpc.ManagementServiceStub>
implements RpcManagementClient {
    private final MeshKeyManager keyManager;
    private final MeshClient meshClient;
    private final GitRepositorySupplier repositorySupplier;
    private final StorageService storageService;
    private final Duration supportZipTimeout;

    public GrpcManagementClient(I18nService i18nService, MeshKeyManager keyManager, MeshClient meshClient, GitRepositorySupplier repositorySupplier, GitRequestHelper requestHelper, StorageService storageService, Duration supportZipTimeout, MeshStub<ManagementServiceGrpc.ManagementServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.keyManager = keyManager;
        this.meshClient = meshClient;
        this.repositorySupplier = repositorySupplier;
        this.storageService = storageService;
        this.supportZipTimeout = supportZipTimeout;
    }

    public boolean addDataStore(@Nonnull DataStore dataStore) {
        Objects.requireNonNull(dataStore, "dataStore");
        return this.stub.forSidecar().map(sidecar -> {
            UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
            RpcAddDataStoreRequest request = RpcAddDataStoreRequest.newBuilder().setId(Long.toString(dataStore.getId())).setPath(dataStore.getPath()).build();
            this.requestHelper.applyTimeout(sidecar, (MessageOrBuilder)request, null).addDataStore(request, observer);
            return ((RpcAddDataStoreResponse)observer.asResult()).getSuccess();
        }).orElse(false);
    }

    @Nonnull
    public CompletionStage<Void> drainNode(@Nonnull MeshNode node) {
        return this.drain(node, RpcDrainRequest.newBuilder().setAllRequest(RpcAllRequest.getDefaultInstance()));
    }

    @Nonnull
    public CompletionStage<Void> drainReplica(@Nonnull MeshPartitionReplica replica) {
        return this.drain(replica.getNode(), RpcDrainRequest.newBuilder().setPartitionsRequest(RpcPartitionsRequest.newBuilder().addPartitions(RemoteRepositoryId.getPartitionHex((int)replica.getPartition()))));
    }

    @Nonnull
    public List<RemoteDataStore> getDataStores(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        RpcGetDataStoresRequest request = RpcGetDataStoresRequest.getDefaultInstance();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
        this.requestHelper.applyTimeout((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).getDataStores(request, observer);
        return (List)((RpcGetDataStoresResponse)observer.asResult()).getDataStoresList().stream().map(RpcUtils::toRemoteDataStore).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public Map<String, String> getNodeInfo(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        RpcGetNodeInfoRequest request = RpcGetNodeInfoRequest.getDefaultInstance();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
        this.requestHelper.applyTimeout((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).getNodeInfo(request, observer);
        return ((RpcGetNodeInfoResponse)observer.asResult()).getPropertiesMap();
    }

    @Nonnull
    public Optional<SupportInfo> getSupportInfo(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        RpcGetSupportInfoRequest request = RpcGetSupportInfoRequest.getDefaultInstance();
        OptionalResponseObserver observer = new OptionalResponseObserver(node);
        this.requestHelper.applyTimeout((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).getSupportInfo(request, observer);
        return ((Optional)observer.asResult()).map(SupportInfo::toSupportInfo);
    }

    @Nonnull
    public Path getSupportZip(@Nonnull MeshNode node, @Nonnull RpcGetSupportZipRequest request) throws IOException {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(request, "request");
        GetSupportZipResponseObserver responseObserver = new GetSupportZipResponseObserver(node, new DefaultErrorTranslator(this.i18nService, null), this.storageService);
        this.requestHelper.applyTimeout((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, this.supportZipTimeout).getSupportZip(request, (StreamObserver)responseObserver);
        return (Path)responseObserver.asResult();
    }

    public void markRepositoriesInconsistent(@Nonnull MeshNode node, @Nonnull RpcMarkRepositoriesInconsistentRequest request) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(request, "request");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
        this.requestHelper.applyTimeout((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).markRepositoriesInconsistent(request, observer);
        observer.asResult();
    }

    public long ping(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        ConnectivityErrorTranslator errorTranslator = new ConnectivityErrorTranslator(this.i18nService, node.getRpcUrl());
        UnaryResponseObserver observer = new UnaryResponseObserver(errorTranslator);
        long start = System.currentTimeMillis();
        this.requestHelper.applyTimeout((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node), null).heartbeat(RpcHeartbeat.getDefaultInstance(), observer);
        observer.asResult();
        long end = System.currentTimeMillis();
        return end - start;
    }

    @Nonnull
    public Optional<PublicKey> provisionNode(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        ConnectivityErrorTranslator errorTranslator = new ConnectivityErrorTranslator(this.i18nService, node.getRpcUrl());
        ManagedChannel channel = null;
        try {
            channel = this.meshClient.openChannel(node);
            RpcProvisionNodeRequest request = RpcProvisionNodeRequest.newBuilder().setNodeId(Long.toString(node.getId())).setPublicKey(RpcUtils.toPublicKey(this.keyManager.getSigningKey().getPublic())).build();
            UnaryResponseObserver observer = new UnaryResponseObserver(errorTranslator);
            this.requestHelper.applyTimeout(ManagementServiceGrpc.newStub((Channel)channel), (MessageOrBuilder)request, null).provisionNode(request, observer);
            RpcProvisionNodeResponse response = (RpcProvisionNodeResponse)observer.asResult();
            Optional<PublicKey> optional = response.hasPublicKey() ? Optional.of(RpcUtils.toPublicKey(response.getPublicKey())) : Optional.empty();
            return optional;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw errorTranslator.translate(e);
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    @Nonnull
    public CompletableFuture<Boolean> repairRepository(@Nonnull MeshNode sourceNode, @Nonnull MeshNode targetNode, @Nonnull Repository repository) {
        Objects.requireNonNull(sourceNode, "sourceNode");
        Objects.requireNonNull(targetNode, "targetNode");
        Objects.requireNonNull(repository, "repository");
        return this.repairRepository(sourceNode, targetNode, repository, repository);
    }

    @Nonnull
    public CompletableFuture<Boolean> repairRepository(@Nonnull MeshNode sourceNode, @Nonnull MeshNode targetNode, @Nonnull Repository sourceRepository, @Nonnull Repository targetRepository) {
        MeshNode node;
        Objects.requireNonNull(sourceNode, "sourceNode");
        Objects.requireNonNull(targetNode, "targetNode");
        Objects.requireNonNull(sourceRepository, "sourceRepository");
        Objects.requireNonNull(targetRepository, "targetRepository");
        RpcRepairRepositoryRequest.Builder builder = RpcRepairRepositoryRequest.newBuilder().setRepository(this.requestHelper.toRepositoryId(targetRepository)).setSourceRepository(this.requestHelper.toRepositoryId(sourceRepository));
        if (sourceNode.isSidecar()) {
            node = sourceNode;
            builder.setTarget(targetNode.getRpcId());
        } else {
            node = targetNode;
            builder.setSources(RpcNodeIdList.newBuilder().addNodes(sourceNode.getRpcId()));
        }
        AbstractFutureResponseObserver<RpcRepairRepositoryRequest, RpcRepairRepositoryResponse, Boolean> observer = new AbstractFutureResponseObserver<RpcRepairRepositoryRequest, RpcRepairRepositoryResponse, Boolean>(this, (ErrorTranslator)new DefaultErrorTranslator(this.i18nService, sourceRepository)){

            public void onNext(RpcRepairRepositoryResponse value) {
                this.setResult(value.getState() == RpcReplicaState.REPLICA_STATE_CONSISTENT);
            }
        };
        ((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node)).repairRepository(builder.build(), (StreamObserver)observer);
        return observer.asFuture();
    }

    public void replaceReadOnlyRepositories(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        this.repositorySupplier.streamReadOnly(this.readOnlyCallbackForNode((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node)));
    }

    public int resetHierarchy(@Nonnull MeshNode node, int partitionId, @Nonnull String hierarchyId) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (Object)"partitionId must be >= 0");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
        ((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node)).resetHierarchy(RpcResetHierarchyRequest.newBuilder().setHierarchy(hierarchyId).setPartition(RemoteRepositoryId.getPartitionHex((int)partitionId)).build(), observer);
        return ((RpcResetHierarchyResponse)observer.asResult()).getResetCount();
    }

    public void setReplicaState(@Nonnull MeshNode node, @Nonnull Repository repository, @Nonnull RpcSetReplicaStateRequest.Builder requestBuilder) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcSetReplicaStateRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node)).setReplicaState(request, observer);
        observer.asResult();
    }

    public void setRepositoryReadOnly(@Nonnull MeshNode node, @Nonnull Repository repository, boolean readOnly) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(repository, "repository");
        RpcSetRepositoryReadOnlyRequest request = this.buildSetRepositoryReadOnlyRequest(repository, readOnly);
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(Objects.requireNonNull(node, "node"))).setRepositoryReadOnly(request, observer);
    }

    public void updateConfig(@Nonnull MeshNode node, @Nonnull RpcSetConfigurationRequest request) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(request, "request");
        UnaryResponseObserver observer = new UnaryResponseObserver(new SigningErrorTranslator(this.i18nService, null));
        this.requestHelper.applyTimeout((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).setConfiguration(request, observer);
        observer.asResult();
    }

    private RpcSetRepositoryReadOnlyRequest buildSetRepositoryReadOnlyRequest(Repository repository, boolean readOnly) {
        return RpcSetRepositoryReadOnlyRequest.newBuilder().setRepository(this.requestHelper.toRepositoryId(repository)).setReadOnly(readOnly).build();
    }

    private CompletionStage<Void> drain(@Nonnull MeshNode node, @Nonnull RpcDrainRequest.Builder requestBuilder) {
        Objects.requireNonNull(node, "node");
        DrainResponseObserver responseObserver = new DrainResponseObserver(node);
        ((ManagementServiceGrpc.ManagementServiceStub)this.stub.forNode(node)).drain(requestBuilder.build(), (StreamObserver)responseObserver);
        return responseObserver.asFuture();
    }

    private RepositoryCallback readOnlyCallbackForNode(final ManagementServiceGrpc.ManagementServiceStub stub) {
        return new RepositoryCallback(){
            private RpcReplaceReadOnlyRepositoriesFragment.Builder builder;
            private StreamObserver<RpcReplaceReadOnlyRepositoriesFragment> requestObserver;
            private UnaryResponseObserver<RpcReplaceReadOnlyRepositoriesResponse> responseObserver;
            private boolean sendRequired = true;

            public void onEnd() {
                if (this.sendRequired) {
                    this.requestObserver.onNext((Object)this.builder.build());
                }
                this.requestObserver.onCompleted();
                this.responseObserver.asResult();
            }

            public boolean onRepository(@Nonnull Repository repository) {
                try {
                    this.builder.addRepositories(GrpcManagementClient.this.requestHelper.toRepositoryId(repository));
                    this.sendRequired = true;
                    if (this.builder.getRepositoriesList().size() >= 1000) {
                        this.requestObserver.onNext((Object)this.builder.build());
                        this.sendRequired = false;
                        this.builder = RpcReplaceReadOnlyRepositoriesFragment.newBuilder();
                    }
                }
                catch (RuntimeException e) {
                    this.requestObserver.onError((Throwable)e);
                    return false;
                }
                return true;
            }

            public void onStart() {
                this.responseObserver = new UnaryResponseObserver(new DefaultErrorTranslator(GrpcManagementClient.this.i18nService, null));
                this.requestObserver = stub.replaceReadOnlyRepositories(this.responseObserver);
                this.builder = RpcReplaceReadOnlyRepositoriesFragment.newBuilder();
            }
        };
    }

    private static class OptionalResponseObserver<T>
    extends AbstractFutureResponseObserver<Object, T, Optional<T>> {
        private static final Logger log = LoggerFactory.getLogger(OptionalResponseObserver.class);
        private final MeshNode node;

        private OptionalResponseObserver(MeshNode node) {
            this.node = node;
        }

        @Override
        public void onError(Throwable t) {
            log.error("Cannot retrieve response from {}", (Object)this.node.getRpcUrl(), (Object)t);
            this.setResult(Optional.empty());
            this.onCompleted();
        }

        public void onNext(T result) {
            this.setResult(Optional.of(result));
        }
    }
}

