/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.PackCacheServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcClearPackCacheRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPackCacheStatisticsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPackCacheStatisticsResponse;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.PackCacheStatistics;
import com.atlassian.stash.internal.scm.git.mesh.RpcPackCacheClient;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.google.protobuf.MessageOrBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@Profiled
public class GrpcPackCacheClient
extends AbstractGrpcClient<PackCacheServiceGrpc.PackCacheServiceStub>
implements RpcPackCacheClient {
    private final GitRequestHelper requestHelper;

    public GrpcPackCacheClient(I18nService i18nService, GitRequestHelper requestHelper, MeshStub<PackCacheServiceGrpc.PackCacheServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.requestHelper = requestHelper;
    }

    @Override
    public void clear(@Nullable Repository repository, @Nonnull RpcClearPackCacheRequest.Builder requestBuilder) {
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        ArrayList observers = new ArrayList();
        RpcClearPackCacheRequest request = repository == null ? this.requestHelper.prepareBuilder(requestBuilder).build() : this.prepareBuilder(repository, requestBuilder).build();
        Stream<PackCacheServiceGrpc.PackCacheServiceStub> stubs = repository == null ? this.getAllStubsWithDeadline((MessageOrBuilder)request) : Stream.of((PackCacheServiceGrpc.PackCacheServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request));
        stubs.forEach(stub -> {
            UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
            stub.clear(request, observer);
            observers.add(observer);
        });
        GrpcPackCacheClient.awaitAll(observers);
    }

    @Override
    public void clearSidecar() {
        this.stub.forSidecar().ifPresent(sidecar -> {
            UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
            this.requestHelper.applyTimeout(sidecar, null).clear(RpcClearPackCacheRequest.getDefaultInstance(), observer);
            observer.asResult();
        });
    }

    @Override
    @Nonnull
    public PackCacheStatistics getStatistics(@Nullable Repository repository) {
        RpcGetPackCacheStatisticsRequest.Builder requestBuilder = RpcGetPackCacheStatisticsRequest.newBuilder();
        RpcGetPackCacheStatisticsRequest request = repository == null ? this.requestHelper.prepareBuilder(requestBuilder).build() : this.prepareBuilder(repository, requestBuilder).build();
        Stream<PackCacheServiceGrpc.PackCacheServiceStub> stubs = repository == null ? this.getAllStubsWithDeadline((MessageOrBuilder)request) : Stream.of((PackCacheServiceGrpc.PackCacheServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request));
        ArrayList observers = new ArrayList();
        stubs.forEach(stub -> {
            UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
            observers.add(observer);
            stub.getStatistics(request, observer);
        });
        List<RpcGetPackCacheStatisticsResponse> responses = GrpcPackCacheClient.awaitAll(observers);
        long totalHits = 0L;
        long totalMisses = 0L;
        long totalSize = 0L;
        for (RpcGetPackCacheStatisticsResponse response : responses) {
            totalHits += response.getHits();
            totalMisses += response.getMisses();
            totalSize += response.getSize();
        }
        return new PackCacheStatistics(totalHits, totalMisses, totalSize);
    }
}

