/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.CompositeNioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.PlumbingServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCallRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCallStdinFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCatFileBatchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCatFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCatFileStdinFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListStdinFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.command.revlist.RevCoreExitHandler;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.BidirectionalFragmentResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.FragmentResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RequestFragmentCreator;
import com.atlassian.stash.internal.scm.git.mesh.RpcPlumbingClient;
import com.atlassian.stash.internal.scm.git.mesh.worktree.MeshGitWorkTree;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

@Profiled
public class GrpcPlumbingClient
extends AbstractGrpcClient<PlumbingServiceGrpc.PlumbingServiceStub>
implements RpcPlumbingClient {
    public GrpcPlumbingClient(I18nService i18nService, GitRequestHelper requestHelper, MeshStub<PlumbingServiceGrpc.PlumbingServiceStub> stub) {
        super(i18nService, requestHelper, stub);
    }

    @Override
    public <T> T call(@Nonnull Repository repository, @Nonnull Set<Repository> related, @Nonnull RpcCallRequest.Builder requestBuilder, @Nonnull NioStdoutHandler<T> handler, @Nonnull CommandExitHandler exitHandler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(handler, "handler");
        Objects.requireNonNull(exitHandler, "exitHandler");
        FragmentResponseObserver<T> observer = new FragmentResponseObserver<T>(handler, (ErrorTranslator)new DefaultErrorTranslator(this.i18nService, repository), exitHandler, this.i18nService);
        RpcCallRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((PlumbingServiceGrpc.PlumbingServiceStub)this.getStubWithDeadline(repository, related, (MessageOrBuilder)request)).call(request, observer);
        return observer.asResult();
    }

    @Override
    public <T> T call(@Nonnull Repository repository, @Nonnull Set<Repository> related, @Nonnull RpcCallRequest.Builder requestBuilder, @Nonnull NioStdioHandler<T> stdioHandler, @Nonnull CommandExitHandler exitHandler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(stdioHandler, "stdioHandler");
        Objects.requireNonNull(exitHandler, "exitHandler");
        this.prepareBuilder(repository, requestBuilder);
        BidirectionalFragmentResponseObserver<RpcCallStdinFragment, T> observer = new BidirectionalFragmentResponseObserver<RpcCallStdinFragment, T>(stdioHandler, new DefaultErrorTranslator(this.i18nService, repository), exitHandler, new CallRequestFragmentCreator(requestBuilder), this.i18nService);
        ((PlumbingServiceGrpc.PlumbingServiceStub)this.getStubWithDeadline(repository, related, (MessageOrBuilder)requestBuilder)).callStdin(observer);
        return observer.asResult();
    }

    @Override
    public <T> T call(@Nonnull MeshGitWorkTree workTree, @Nonnull RpcCallRequest.Builder requestBuilder, @Nonnull NioStdioHandler<T> stdioHandler, @Nonnull CommandExitHandler exitHandler) {
        Objects.requireNonNull(workTree, "worktree");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(stdioHandler, "stdioHandler");
        Objects.requireNonNull(exitHandler, "exitHandler");
        this.prepareBuilder(workTree, requestBuilder);
        BidirectionalFragmentResponseObserver<RpcCallStdinFragment, T> observer = new BidirectionalFragmentResponseObserver<RpcCallStdinFragment, T>(stdioHandler, new DefaultErrorTranslator(this.i18nService, workTree.getRepository()), exitHandler, new CallRequestFragmentCreator(requestBuilder), this.i18nService);
        ((PlumbingServiceGrpc.PlumbingServiceStub)this.getStubWithDeadline(workTree, (MessageOrBuilder)requestBuilder)).callStdin(observer);
        return observer.asResult();
    }

    @Override
    public <T> T catFile(@Nonnull Repository repository, @Nonnull RpcCatFileRequest.Builder requestBuilder, @Nonnull NioStdoutHandler<T> handler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(handler, "handler");
        FragmentResponseObserver<T> observer = new FragmentResponseObserver<T>(handler, (ErrorTranslator)new DefaultErrorTranslator(this.i18nService, repository), (CommandExitHandler)new GitCommandExitHandler(this.i18nService, repository), this.i18nService);
        RpcCatFileRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((PlumbingServiceGrpc.PlumbingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).catFile(request, observer);
        return observer.asResult();
    }

    @Override
    public <T> T catFileBatch(@Nonnull Repository repository, @Nonnull RpcCatFileBatchRequest.Builder requestBuilder, @Nonnull NioStdioHandler<T> stdioHandler) {
        return this.doCatFileBatch(repository, requestBuilder, stdioHandler, observer -> ((PlumbingServiceGrpc.PlumbingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder)).catFileBatch(observer));
    }

    @Override
    public <T> T revList(@Nonnull Repository repository, @Nonnull RpcRevListRequest.Builder requestBuilder, @Nonnull NioStdoutHandler<T> handler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(handler, "handler");
        FragmentResponseObserver<T> observer = new FragmentResponseObserver<T>(handler, (ErrorTranslator)new DefaultErrorTranslator(this.i18nService, repository), (CommandExitHandler)new RevCoreExitHandler(this.i18nService, repository, requestBuilder.getRevListOptionsOrBuilder()), this.i18nService);
        RpcRevListRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((PlumbingServiceGrpc.PlumbingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).revList(request, observer);
        return observer.asResult();
    }

    @Override
    public <T> T revList(@Nonnull Repository repository, final @Nonnull RpcRevListRequest.Builder requestBuilder, @Nonnull NioStdinHandler stdinHandler, @Nonnull NioStdoutHandler<T> stdoutHandler) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(stdinHandler, "stdinHandler");
        Objects.requireNonNull(stdoutHandler, "stdoutHandler");
        this.prepareBuilder(repository, requestBuilder);
        BidirectionalFragmentResponseObserver responseObserver = new BidirectionalFragmentResponseObserver(new CompositeNioStdioHandler(stdoutHandler, stdinHandler), new DefaultErrorTranslator(this.i18nService, repository), (CommandExitHandler)new RevCoreExitHandler(this.i18nService, repository, requestBuilder.getRevListOptionsOrBuilder()), new RequestFragmentCreator<RpcRevListStdinFragment>(){

            @Override
            @Nonnull
            public RpcRevListStdinFragment forStdin(@Nonnull RpcStreamChunk stdin) {
                Objects.requireNonNull(stdin, "stdin");
                return RpcRevListStdinFragment.newBuilder().setStdin(stdin).build();
            }

            @Override
            @Nonnull
            public RpcRevListStdinFragment getInitial() {
                return RpcRevListStdinFragment.newBuilder().setRequest(requestBuilder).build();
            }
        }, this.i18nService);
        ((PlumbingServiceGrpc.PlumbingServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder)).revListStdin(responseObserver);
        return responseObserver.asResult();
    }

    private <T> T doCatFileBatch(Repository repository, final RpcCatFileBatchRequest.Builder requestBuilder, NioStdioHandler<T> stdioHandler, Consumer<StreamObserver<RpcStreamFragment>> onRpc) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        this.prepareBuilder(repository, requestBuilder);
        BidirectionalFragmentResponseObserver<RpcCatFileStdinFragment, T> observer = new BidirectionalFragmentResponseObserver<RpcCatFileStdinFragment, T>(stdioHandler, new DefaultErrorTranslator(this.i18nService, repository), (CommandExitHandler)new GitCommandExitHandler(this.i18nService, repository), new RequestFragmentCreator<RpcCatFileStdinFragment>(){

            @Override
            @Nonnull
            public RpcCatFileStdinFragment forStdin(@Nonnull RpcStreamChunk stdin) {
                Objects.requireNonNull(stdin, "stdin");
                return RpcCatFileStdinFragment.newBuilder().setStdin(stdin).build();
            }

            @Override
            @Nonnull
            public RpcCatFileStdinFragment getInitial() {
                return RpcCatFileStdinFragment.newBuilder().setRequest(requestBuilder).build();
            }
        }, this.i18nService);
        onRpc.accept((StreamObserver<RpcStreamFragment>)observer);
        return observer.asResult();
    }

    private static class CallRequestFragmentCreator
    implements RequestFragmentCreator<RpcCallStdinFragment> {
        private final RpcCallRequest.Builder requestBuilder;

        private CallRequestFragmentCreator(RpcCallRequest.Builder requestBuilder) {
            this.requestBuilder = requestBuilder;
        }

        @Override
        @Nonnull
        public RpcCallStdinFragment forStdin(@Nonnull RpcStreamChunk stdin) {
            Objects.requireNonNull(stdin, "stdin");
            return RpcCallStdinFragment.newBuilder().setStdin(stdin).build();
        }

        @Override
        @Nonnull
        public RpcCallStdinFragment getInitial() {
            return RpcCallStdinFragment.newBuilder().setRequest(this.requestBuilder).build();
        }
    }
}

