/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.content.SimpleDiffStatsSummary;
import com.atlassian.bitbucket.dmz.hook.SimpleMergeQueueHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.hook.repository.SimplePullRequestMergeHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.PullRequestServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAcceptMergePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAcceptMergePullRequestResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchRescopePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchUpdatePullRequestRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchUpdatePullRequestRefsResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeletePullRequestRequestById;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeletePullRequestResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStatsSummary;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffStatsSummaryResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestChangesRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestDiffParsedRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestDiffStatsSummaryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestEffectiveDiffRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestEffectiveDiffResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergePullRequestFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergePullRequestResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPrepareMergePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPrepareMergePullRequestRequestFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPrepareMergePullRequestResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequestEffectiveDiff;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequestRefUpdates;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequestRescope;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefUpdate;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRunPullRequestMergeHooks;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTryPullRequestMergeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdatePullRequestRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdatePullRequestRefsResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRef;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.event.GitPullRequestRefsChangedEvent;
import com.atlassian.bitbucket.scm.pull.BulkRescopeContext;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.merge.GitMergeStrategy;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.BatchRescopePullRequestResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ConversationalResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DeletePullRequestErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DiffResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.PullRequestChangesResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.PullRequestCommitsResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.PullRequestErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RequestMessageCreator;
import com.atlassian.stash.internal.scm.git.mesh.RpcPullRequestClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Profiled
public class GrpcPullRequestClient
extends AbstractGrpcClient<PullRequestServiceGrpc.PullRequestServiceStub>
implements RpcPullRequestClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcPullRequestClient.class);
    private final EventPublisher eventPublisher;
    private final RepositoryHookService hookService;
    private final Duration pullRequestOperationTimeout;

    public GrpcPullRequestClient(EventPublisher eventPublisher, RepositoryHookService hookService, I18nService i18nService, Duration pullRequestOperationTimeout, GitRequestHelper requestHelper, MeshStub<PullRequestServiceGrpc.PullRequestServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.eventPublisher = eventPublisher;
        this.hookService = hookService;
        this.pullRequestOperationTimeout = pullRequestOperationTimeout;
    }

    @Override
    @Nonnull
    public Branch acceptMerge(@Nonnull PullRequest pullRequest, @Nonnull RpcAcceptMergePullRequestRequest.Builder requestBuilder) {
        requestBuilder.setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper));
        UnaryResponseObserver responseObserver = new UnaryResponseObserver(new PullRequestErrorTranslator(this.i18nService, pullRequest));
        this.getStubWithDeadline(pullRequest, (MessageOrBuilder)requestBuilder, this.pullRequestOperationTimeout).acceptMerge(requestBuilder.build(), responseObserver);
        RpcAcceptMergePullRequestResponse result = (RpcAcceptMergePullRequestResponse)responseObserver.asResult();
        return RpcUtils.toBranch(result.getBranch());
    }

    @Override
    public void batchRescope(@Nonnull Repository repository, @Nonnull BulkRescopeContext context, @Nonnull RpcBatchRescopePullRequestRequest.Builder requestBuilder) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "request");
        HashBiMap idCache = HashBiMap.create((int)8);
        ImmutableMap.Builder rescopes = ImmutableMap.builder();
        long correlationId = 0L;
        for (PullRequestRescope rescope : context) {
            rescopes.put((Object)(++correlationId), (Object)rescope);
            RpcPullRequestRescope.Builder builder = RpcPullRequestRescope.newBuilder().setFromRepository(this.getRepositoryId((BiMap<Integer, String>)idCache, rescope.getFromRepository())).setOldFromCommit(rescope.getOldFromHash()).setOldToCommit(rescope.getOldToHash()).setRescopeId(correlationId).setToRepository(this.getRepositoryId((BiMap<Integer, String>)idCache, rescope.getToRepository()));
            if (rescope.getNewFromHash() != null) {
                builder.setNewFromCommit(rescope.getNewFromHash());
            }
            if (rescope.getNewToHash() != null) {
                builder.setNewToCommit(rescope.getNewToHash());
            }
            requestBuilder.addRescopes(builder.build());
        }
        if (requestBuilder.getRescopesCount() == 0) {
            return;
        }
        BatchRescopePullRequestResponseObserver observer = new BatchRescopePullRequestResponseObserver(repository, context, arg_0 -> ((ImmutableMap)rescopes.build()).get(arg_0));
        this.requestHelper.prepareBuilder(repository, requestBuilder);
        ((PullRequestServiceGrpc.PullRequestServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)requestBuilder)).batchRescope(requestBuilder.build(), (StreamObserver)observer);
        observer.asResult();
        log.debug("[{}] Batch rescope completed", (Object)repository);
    }

    @Override
    public void batchUpdateRefs(@Nonnull Collection<PullRequest> pullRequests) {
        Objects.requireNonNull(pullRequests, "pullRequests");
        if (pullRequests.isEmpty()) {
            return;
        }
        HashMap<String, Integer> repositoryIds = new HashMap<String, Integer>();
        Repository repository = pullRequests.iterator().next().getToRef().getRepository();
        RpcBatchUpdatePullRequestRefsRequest.Builder request = RpcBatchUpdatePullRequestRefsRequest.newBuilder();
        for (PullRequest pullRequest : pullRequests) {
            RpcPullRequest rpc = RpcUtils.toPullRequest(pullRequest, this.requestHelper);
            repositoryIds.put(rpc.getFromRef().getRepository(), pullRequest.getFromRef().getRepository().getId());
            repositoryIds.put(rpc.getToRef().getRepository(), pullRequest.getToRef().getRepository().getId());
            request.addPullRequests(rpc);
        }
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        Duration timeout = Duration.ofMillis(this.pullRequestOperationTimeout.toMillis() * (long)pullRequests.size());
        ((PullRequestServiceGrpc.PullRequestServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, timeout)).batchUpdateRefs(request.build(), observer);
        List refUpdates = ((RpcBatchUpdatePullRequestRefsResponse)observer.asResult()).getRefUpdatesList();
        this.maybeFireBatchRefsChanged(repository, pullRequests, repositoryIds, refUpdates);
    }

    @Override
    public void delete(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        this.delete(pullRequest.getToRef().getRepository(), pullRequest.getId());
    }

    @Override
    public void delete(@Nonnull Repository repository, long pullRequestId) {
        Objects.requireNonNull(repository, "repository");
        RpcDeletePullRequestRequestById request = RpcDeletePullRequestRequestById.newBuilder().setRepository(this.requestHelper.toRepositoryId(repository)).setId(pullRequestId).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DeletePullRequestErrorTranslator(this.i18nService, repository, pullRequestId));
        ((PullRequestServiceGrpc.PullRequestServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, this.pullRequestOperationTimeout)).deleteById(request, observer);
        List refUpdates = ((RpcDeletePullRequestResponse)observer.asResult()).getRefUpdatesList();
        this.maybeFireRefsDeleted(repository, pullRequestId, refUpdates);
    }

    @Override
    public void getChanges(@Nonnull PullRequest pullRequest, @Nonnull RpcGetPullRequestChangesRequest.Builder requestBuilder, @Nonnull ChangeCallback callback, @Nonnull ChangeContext context) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(context, "context");
        RpcGetPullRequestChangesRequest request = requestBuilder.setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).build();
        PullRequestChangesResponseObserver observer = new PullRequestChangesResponseObserver(callback, this.i18nService, pullRequest.getToRef().getRepository(), context);
        this.getStubWithDeadline(pullRequest, (MessageOrBuilder)request, this.pullRequestOperationTimeout).getChanges(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void getCommits(@Nonnull PullRequest pullRequest, @Nonnull RpcGetPullRequestCommitsRequest.Builder requestBuilder, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RpcGetPullRequestCommitsRequest request = requestBuilder.setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).build();
        PullRequestCommitsResponseObserver observer = new PullRequestCommitsResponseObserver(callback, this.i18nService, pullRequest.getToRef().getRepository());
        this.getStubWithDeadline(pullRequest, (MessageOrBuilder)request, this.pullRequestOperationTimeout).getCommits(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void getDiff(@Nonnull PullRequest pullRequest, @Nonnull RpcGetPullRequestDiffParsedRequest.Builder requestBuilder, @Nonnull DiffContentCallback callback, @Nonnull DiffContext context) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(context, "context");
        RpcGetPullRequestDiffParsedRequest request = requestBuilder.setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).setMaxLineLength(context.getMaxLineLength()).setMaxLines(context.getMaxLines()).build();
        Repository repository = pullRequest.getToRef().getRepository();
        DiffResponseObserver observer = new DiffResponseObserver(callback, context, this.i18nService, repository);
        ((PullRequestServiceGrpc.PullRequestServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getDiffParsed(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public DiffStatsSummary getDiffStatsSummary(@Nonnull PullRequest pullRequest, @Nonnull RpcGetPullRequestDiffStatsSummaryRequest.Builder requestBuilder) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcGetPullRequestDiffStatsSummaryRequest request = requestBuilder.setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).build();
        Repository repository = pullRequest.getToRef().getRepository();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((PullRequestServiceGrpc.PullRequestServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getDiffStatsSummary(request, observer);
        RpcDiffStatsSummary diffStatsSummary = ((RpcDiffStatsSummaryResponse)observer.asResult()).getDiffStatsSummary();
        return new SimpleDiffStatsSummary.Builder().filesChanged(diffStatsSummary.getFilesChanged()).totalDeletions(diffStatsSummary.getTotalDeletions()).totalInsertions(diffStatsSummary.getTotalInsertions()).build();
    }

    @Override
    @Nonnull
    public PullRequestEffectiveDiff getEffectiveDiff(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        RpcGetPullRequestEffectiveDiffRequest request = RpcGetPullRequestEffectiveDiffRequest.newBuilder().setAllowUnrelated(true).setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new PullRequestErrorTranslator(this.i18nService, pullRequest));
        this.getStubWithDeadline(pullRequest, (MessageOrBuilder)request, this.pullRequestOperationTimeout).getEffectiveDiff(request, observer);
        RpcPullRequestEffectiveDiff effectiveDiff = ((RpcGetPullRequestEffectiveDiffResponse)observer.asResult()).getEffectiveDiff();
        this.maybeFireRefsChanged(pullRequest, effectiveDiff.getRefUpdatesList());
        return new PullRequestEffectiveDiff(effectiveDiff.getToCommit(), effectiveDiff.getFromCommit());
    }

    @Override
    @Nonnull
    public Branch merge(@Nonnull PullRequest pullRequest, @Nonnull RpcMergePullRequestRequest.Builder requestBuilder, String strategyId, boolean autoMerge) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcMergePullRequestRequest request = this.prepareBuilder(requestBuilder.setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).setStrategy(this.toMergeStrategy(strategyId).toRpc())).build();
        PullRequestErrorTranslator errorTranslator = new PullRequestErrorTranslator(this.i18nService, pullRequest);
        PullRequestServiceGrpc.PullRequestServiceStub stub = this.getStub(pullRequest);
        ConversationalResponseObserver<RpcMergePullRequestFragment, RpcMergePullRequestResponseFragment> responseObserver = new ConversationalResponseObserver<RpcMergePullRequestFragment, RpcMergePullRequestResponseFragment>(errorTranslator, new PullRequestMergeRequestMessageCreator(pullRequest, request, strategyId, autoMerge, this.getTargetNode(stub)));
        stub.merge(responseObserver);
        RpcMergePullRequestResponseFragment response = responseObserver.asResult();
        if (response.hasMergeResponse()) {
            RpcMergeResponse mergeResponse = response.getMergeResponse();
            switch (mergeResponse.getResponseOneofCase()) {
                case BRANCH: {
                    return RpcUtils.toBranch(mergeResponse.getBranch());
                }
                case CONFLICTS: {
                    throw errorTranslator.translateMergeConflicts(mergeResponse.getConflicts());
                }
            }
        }
        PullRequestRef fromRef = pullRequest.getFromRef();
        PullRequestRef toRef = pullRequest.getToRef();
        KeyedMessage message = pullRequest.isCrossRepository() ? this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.interrepository", new Object[]{fromRef.getRepository().getProject().getKey(), fromRef.getRepository().getSlug(), toRef.getRepository().getProject().getKey(), toRef.getRepository().getSlug(), fromRef.getDisplayId(), fromRef.getLatestCommit(), toRef.getDisplayId()}) : this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.intrarepository", new Object[]{toRef.getRepository().getProject().getKey(), toRef.getRepository().getSlug(), fromRef.getDisplayId(), fromRef.getLatestCommit(), toRef.getDisplayId()});
        throw new MergeException(message, "git", toRef.getRepository(), fromRef.getDisplayId(), toRef.getDisplayId(), false);
    }

    @Override
    @Nonnull
    public Branch prepareMerge(final @Nonnull PullRequest pullRequest, final @Nonnull RpcPrepareMergePullRequestRequest.Builder requestBuilder, @Nonnull String strategyId) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        requestBuilder.getMergeRequestBuilder().setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).setStrategy(this.toMergeStrategy(strategyId).toRpc());
        final RpcPrepareMergePullRequestRequest request = this.prepareBuilder(requestBuilder).build();
        PullRequestErrorTranslator errorTranslator = new PullRequestErrorTranslator(this.i18nService, pullRequest);
        PullRequestServiceGrpc.PullRequestServiceStub stub = this.getStub(pullRequest);
        final MeshNode targetNode = this.getTargetNode(stub);
        ConversationalResponseObserver<RpcPrepareMergePullRequestRequestFragment, RpcPrepareMergePullRequestResponseFragment> responseObserver = new ConversationalResponseObserver<RpcPrepareMergePullRequestRequestFragment, RpcPrepareMergePullRequestResponseFragment>(errorTranslator, new RequestMessageCreator<RpcPrepareMergePullRequestRequestFragment, RpcPrepareMergePullRequestResponseFragment>(){
            boolean more = true;

            @Override
            @Nonnull
            public RpcPrepareMergePullRequestRequestFragment getFirst() {
                return RpcPrepareMergePullRequestRequestFragment.newBuilder().setRequest(request).build();
            }

            @Override
            public RpcPrepareMergePullRequestRequestFragment getNext(@Nonnull RpcPrepareMergePullRequestResponseFragment response) {
                switch (Objects.requireNonNull(response, "fragment").getResponseOneofCase()) {
                    case MERGE_RESPONSE: {
                        return null;
                    }
                    case RUN_MERGE_HOOKS: {
                        this.more = false;
                        RpcRunPullRequestMergeHooks runMergeHooks = response.getRunMergeHooks();
                        GrpcPullRequestClient.this.requestHelper.withQuarantine(pullRequest.getToRef().getRepository(), targetNode, runMergeHooks.getRepository(), () -> {
                            SimpleMergeQueueHookRequest hookRequest = new SimpleMergeQueueHookRequest.Builder(pullRequest.getToRef().getRepository()).temporaryBranch((Branch)((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().id(GitRefPattern.HEADS.qualify(requestBuilder.getTemporaryBranchName()))).displayId(requestBuilder.getTemporaryBranchName())).latestCommit(runMergeHooks.getMergeCommit())).build()).build();
                            RepositoryHookResult result = GrpcPullRequestClient.this.hookService.preUpdate((RepositoryHookRequest)hookRequest);
                            if (result.isRejected()) {
                                throw new RepositoryHookVetoedException(GrpcPullRequestClient.this.i18nService.createKeyedMessage("bitbucket.scm.git.pull.mergecanceled", new Object[]{requestBuilder.getTemporaryBranchName()}), (RepositoryHookRequest)hookRequest, result.getVetoes());
                            }
                        });
                        return RpcPrepareMergePullRequestRequestFragment.newBuilder().setUpdateRef(RpcUpdateRef.getDefaultInstance()).build();
                    }
                }
                throw Status.INVALID_ARGUMENT.withDescription("Received [" + String.valueOf(response.getResponseOneofCase()) + "] where [" + String.valueOf(RpcMergePullRequestResponseFragment.ResponseOneofCase.RUN_MERGE_HOOKS) + "] was expected").asRuntimeException();
            }

            @Override
            public boolean hasMore() {
                return this.more;
            }
        });
        stub.prepareMerge(responseObserver);
        RpcPrepareMergePullRequestResponseFragment response = responseObserver.asResult();
        if (response.hasMergeResponse()) {
            RpcMergeResponse mergeResponse = response.getMergeResponse();
            switch (mergeResponse.getResponseOneofCase()) {
                case BRANCH: {
                    return RpcUtils.toBranch(mergeResponse.getBranch());
                }
                case CONFLICTS: {
                    throw errorTranslator.translateMergeConflicts(mergeResponse.getConflicts());
                }
            }
        }
        PullRequestRef fromRef = pullRequest.getFromRef();
        PullRequestRef toRef = pullRequest.getToRef();
        KeyedMessage message = pullRequest.isCrossRepository() ? this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.interrepository", new Object[]{fromRef.getRepository().getProject().getKey(), fromRef.getRepository().getSlug(), toRef.getRepository().getProject().getKey(), toRef.getRepository().getSlug(), fromRef.getDisplayId(), fromRef.getLatestCommit(), toRef.getDisplayId()}) : this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.intrarepository", new Object[]{toRef.getRepository().getProject().getKey(), toRef.getRepository().getSlug(), fromRef.getDisplayId(), fromRef.getLatestCommit(), toRef.getDisplayId()});
        throw new MergeException(message, "git", toRef.getRepository(), fromRef.getDisplayId(), toRef.getDisplayId(), false);
    }

    @Override
    public void tryMerge(@Nonnull PullRequest pullRequest, @Nonnull RpcMergePullRequestRequest.Builder requestBuilder, String strategyId) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcMergePullRequestRequest request = requestBuilder.setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).setStrategy(this.toMergeStrategy(strategyId).toRpc()).build();
        PullRequestErrorTranslator errorTranslator = new PullRequestErrorTranslator(this.i18nService, pullRequest);
        UnaryResponseObserver observer = new UnaryResponseObserver(errorTranslator);
        this.getStub(pullRequest).tryMerge(request, observer);
        RpcTryPullRequestMergeResponse response = (RpcTryPullRequestMergeResponse)observer.asResult();
        if (response.hasConflicts()) {
            throw errorTranslator.translateMergeConflicts(response.getConflicts());
        }
    }

    @Override
    public void updateRefs(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        RpcUpdatePullRequestRefsRequest request = RpcUpdatePullRequestRefsRequest.newBuilder().setPullRequest(RpcUtils.toPullRequest(pullRequest, this.requestHelper)).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new PullRequestErrorTranslator(this.i18nService, pullRequest));
        this.getStubWithDeadline(pullRequest, (MessageOrBuilder)request, this.pullRequestOperationTimeout).updateRefs(request, observer);
        RpcUpdatePullRequestRefsResponse response = (RpcUpdatePullRequestRefsResponse)observer.asResult();
        this.maybeFireRefsChanged(pullRequest, response.getRefUpdatesList());
    }

    private String getRepositoryId(BiMap<Integer, String> cache, Repository repository) {
        return (String)cache.computeIfAbsent((Object)repository.getId(), id -> this.requestHelper.toRepositoryId(repository));
    }

    private PullRequestServiceGrpc.PullRequestServiceStub getStub(PullRequest pullRequest) {
        return (PullRequestServiceGrpc.PullRequestServiceStub)this.stub.forRepository(pullRequest.getToRef().getRepository());
    }

    private PullRequestServiceGrpc.PullRequestServiceStub getStubWithDeadline(PullRequest pullRequest, MessageOrBuilder message, Duration timeout) {
        return (PullRequestServiceGrpc.PullRequestServiceStub)this.getStubWithDeadline(pullRequest.getToRef().getRepository(), message, timeout);
    }

    private void maybeFireBatchRefsChanged(Repository primaryRepository, Collection<PullRequest> pullRequests, Map<String, Integer> repositoryIds, List<RpcPullRequestRefUpdates> updates) {
        Integer defaultRepositoryId = primaryRepository.getId();
        Map pullRequestByFqId = pullRequests.stream().collect(Collectors.toMap(pr -> pr.getToRef().getRepository().getId() + "#" + pr.getId(), Function.identity()));
        for (RpcPullRequestRefUpdates update : updates) {
            RefChange merge;
            int repositoryId = repositoryIds.getOrDefault(update.getRepository(), defaultRepositoryId);
            PullRequest pullRequest = (PullRequest)pullRequestByFqId.get(repositoryId + "#" + update.getId());
            if (pullRequest == null) {
                log.warn("Could not find pull request {} from repository {} ({})", new Object[]{update.getId(), update.getRepository(), repositoryId});
                continue;
            }
            RefChange from = update.hasFromRefUpdate() ? RpcUtils.toRefChange(update.getFromRefUpdate()) : null;
            RefChange refChange = merge = update.hasMergeRefUpdate() ? RpcUtils.toRefChange(update.getMergeRefUpdate()) : null;
            if (from == null && merge == null) continue;
            this.eventPublisher.publish((Object)new GitPullRequestRefsChangedEvent((Object)this, pullRequest.getToRef().getRepository(), pullRequest.getId(), from, merge));
        }
    }

    private void maybeFireRefsChanged(PullRequest pullRequest, List<RpcRefUpdate> updates) {
        RefChange fromRefChange = null;
        RefChange mergeRefChange = null;
        for (RpcRefUpdate update : updates) {
            String refId = update.getRefId().toStringUtf8();
            if (refId.endsWith("/from")) {
                fromRefChange = RpcUtils.toRefChange(update);
                continue;
            }
            if (!refId.endsWith("/merge")) continue;
            mergeRefChange = RpcUtils.toRefChange(update);
        }
        if (fromRefChange == null && mergeRefChange == null) {
            if (log.isTraceEnabled()) {
                log.trace("{}:{}@{}: No public refs were updated", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), pullRequest.getVersion()});
            }
        } else {
            GitPullRequestRefsChangedEvent refsChangedEvent = new GitPullRequestRefsChangedEvent((Object)this, pullRequest.getToRef().getRepository(), pullRequest.getId(), fromRefChange, mergeRefChange);
            this.eventPublisher.publish((Object)refsChangedEvent);
            if (log.isTraceEnabled()) {
                log.trace("{}:{}@{}: Public refs were updated:\n- From: {}\n- Merge: {}", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), pullRequest.getVersion(), fromRefChange, mergeRefChange});
            }
        }
    }

    private void maybeFireRefsDeleted(Repository repository, long pullRequestId, List<RpcRefUpdate> updates) {
        RefChange fromRefChange = null;
        RefChange mergeRefChange = null;
        for (RpcRefUpdate update : updates) {
            String refId = update.getRefId().toStringUtf8();
            if (refId.endsWith("/from")) {
                fromRefChange = RpcUtils.toRefChange(update);
                continue;
            }
            if (!refId.endsWith("/merge")) continue;
            mergeRefChange = RpcUtils.toRefChange(update);
        }
        if (fromRefChange == null && mergeRefChange == null) {
            if (log.isTraceEnabled()) {
                log.trace("{}:{}: No public refs were updated", (Object)repository, (Object)pullRequestId);
            }
        } else {
            GitPullRequestRefsChangedEvent refsChangedEvent = new GitPullRequestRefsChangedEvent((Object)this, repository, pullRequestId, fromRefChange, mergeRefChange);
            this.eventPublisher.publish((Object)refsChangedEvent);
            if (log.isTraceEnabled()) {
                log.trace("{}:{}: Public refs were updated:\n- From: {}\n- Merge: {}", new Object[]{refsChangedEvent, pullRequestId, fromRefChange, mergeRefChange});
            }
        }
    }

    private GitMergeStrategy toMergeStrategy(String strategyId) {
        if (StringUtils.isBlank((CharSequence)strategyId)) {
            return GitMergeStrategy.NO_FF;
        }
        return GitMergeStrategy.fromId(strategyId).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.merge.unsupportedstrategy", new Object[]{strategyId, Arrays.stream(GitMergeStrategy.values()).map(GitMergeStrategy::getId).collect(Collectors.toList())})));
    }

    private class PullRequestMergeRequestMessageCreator
    implements RequestMessageCreator<RpcMergePullRequestFragment, RpcMergePullRequestResponseFragment> {
        private final boolean autoMerge;
        private final PullRequest pullRequest;
        private final RpcMergePullRequestRequest request;
        private final String strategyId;
        private final MeshNode targetNode;
        private boolean more;

        PullRequestMergeRequestMessageCreator(PullRequest pullRequest, RpcMergePullRequestRequest request, String strategyId, boolean autoMerge, MeshNode targetNode) {
            this.autoMerge = autoMerge;
            this.pullRequest = pullRequest;
            this.request = request;
            this.strategyId = strategyId;
            this.targetNode = targetNode;
            this.more = true;
        }

        @Override
        @Nonnull
        public RpcMergePullRequestFragment getFirst() {
            return RpcMergePullRequestFragment.newBuilder().setMergeRequest(this.request).build();
        }

        @Override
        public RpcMergePullRequestFragment getNext(@Nonnull RpcMergePullRequestResponseFragment response) {
            switch (Objects.requireNonNull(response, "fragment").getResponseOneofCase()) {
                case MERGE_RESPONSE: {
                    return null;
                }
                case RUN_MERGE_HOOKS: {
                    this.more = false;
                    RpcRunPullRequestMergeHooks runMergeHooks = response.getRunMergeHooks();
                    GrpcPullRequestClient.this.requestHelper.withQuarantine(this.pullRequest.getToRef().getRepository(), this.targetNode, runMergeHooks.getRepository(), () -> {
                        SimplePullRequestMergeHookRequest hookRequest = ((SimplePullRequestMergeHookRequest.Builder)new SimplePullRequestMergeHookRequest.Builder(this.pullRequest).autoMerge(this.autoMerge).dryRun(false)).mergeHash(runMergeHooks.getMergeCommit()).message(this.request.getMessage().toStringUtf8()).strategyId(this.strategyId).build();
                        RepositoryHookResult result = GrpcPullRequestClient.this.hookService.preUpdate((RepositoryHookRequest)hookRequest);
                        if (result.isRejected()) {
                            throw new RepositoryHookVetoedException(GrpcPullRequestClient.this.i18nService.createKeyedMessage("bitbucket.scm.git.pull.mergecanceled", new Object[]{hookRequest.getToRef().getDisplayId()}), (RepositoryHookRequest)hookRequest, result.getVetoes());
                        }
                    });
                    return RpcMergePullRequestFragment.newBuilder().setUpdateRef(RpcUpdateRef.getDefaultInstance()).build();
                }
            }
            throw Status.INVALID_ARGUMENT.withDescription("Received [" + String.valueOf(response.getResponseOneofCase()) + "] where [" + String.valueOf(RpcMergePullRequestResponseFragment.ResponseOneofCase.RUN_MERGE_HOOKS) + "] was expected").asRuntimeException();
        }

        @Override
        public boolean hasMore() {
            return this.more;
        }
    }
}

