/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RefServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBranchesRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCheckFormatRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateBranchResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateTagRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateTagResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeleteBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeleteTagRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcLsRemoteRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRawRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveAnnotatedTagRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveDefaultBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveDefaultBranchResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveRefsResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTagsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRefRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRefsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRefsResponse;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.NoSuchTagException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.repository.TagCallback;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTagCallback;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.AnnotatedTagsResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.BranchesResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.CreateBranchErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.CreateTagErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DeleteBranchErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DeleteRefErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.DeleteTagErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RawRefsResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.RefsResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.RpcRefClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.TagsResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Profiled
public class GrpcRefClient
extends AbstractGrpcClient<RefServiceGrpc.RefServiceStub>
implements RpcRefClient {
    public GrpcRefClient(I18nService i18nService, GitRequestHelper requestHelper, MeshStub<RefServiceGrpc.RefServiceStub> stub) {
        super(i18nService, requestHelper, stub);
    }

    @Override
    public void branches(@Nonnull Repository repository, @Nonnull RpcBranchesRequest.Builder requestBuilder, @Nonnull BranchCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        BranchesResponseObserver observer = new BranchesResponseObserver(callback, this.i18nService, repository);
        RpcBranchesRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).branches(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void checkFormat(@Nonnull RpcCheckFormatRequest.Builder requestBuilder) {
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
        RpcCheckFormatRequest request = this.prepareBuilder(requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getAnyStubWithDeadline((MessageOrBuilder)request)).checkFormat(request, observer);
        observer.asResult();
    }

    @Override
    @Nonnull
    public Branch createBranch(@Nonnull Repository repository, @Nonnull RpcCreateBranchRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new CreateBranchErrorTranslator(this.i18nService, repository));
        RpcCreateBranchRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).createBranch(request, observer);
        RpcCreateBranchResponse response = (RpcCreateBranchResponse)observer.asResult();
        if (response.hasBranch()) {
            return RpcUtils.toBranch(response.getBranch());
        }
        String branchName = request.getName().toStringUtf8();
        throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.branch.creationerror", new Object[]{branchName}), branchName);
    }

    @Override
    @Nonnull
    public Tag createTag(@Nonnull Repository repository, @Nonnull RpcCreateTagRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new CreateTagErrorTranslator(this.i18nService, repository));
        RpcCreateTagRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).createTag(request, observer);
        RpcCreateTagResponse response = (RpcCreateTagResponse)observer.asResult();
        if (response.hasTag()) {
            return RpcUtils.toTag(response.getTag());
        }
        String tagName = request.getName().toStringUtf8();
        throw new NoSuchTagException(this.i18nService.createKeyedMessage("bitbucket.service.tag.creationerror", new Object[]{tagName}), tagName);
    }

    @Override
    public void deleteBranch(@Nonnull Repository repository, @Nonnull RpcDeleteBranchRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DeleteBranchErrorTranslator(this.i18nService, repository));
        RpcDeleteBranchRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).deleteBranch(request, observer);
        observer.asResult();
    }

    @Override
    public void deleteTag(@Nonnull Repository repository, @Nonnull RpcDeleteTagRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DeleteTagErrorTranslator(this.i18nService, repository));
        RpcDeleteTagRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).deleteTag(request, observer);
        observer.asResult();
    }

    @Override
    public void lsRemote(@Nonnull Repository repository, @Nonnull RpcLsRemoteRequest.Builder requestBuilder, @Nonnull RefCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RawRefsResponseObserver observer = new RawRefsResponseObserver(callback, this.i18nService, repository);
        RpcLsRemoteRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).lsRemote(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void rawRefs(@Nonnull Repository repository, @Nonnull RpcRawRefsRequest.Builder requestBuilder, @Nonnull RefCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RawRefsResponseObserver observer = new RawRefsResponseObserver(callback, this.i18nService, repository);
        RpcRawRefsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).rawRefs(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void refs(@Nonnull Repository repository, @Nonnull RpcRefsRequest.Builder requestBuilder, @Nonnull RefCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RefsResponseObserver observer = new RefsResponseObserver(callback, this.i18nService, repository);
        RpcRefsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).refs(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void resolveAnnotatedTags(@Nonnull Repository repository, @Nonnull RpcResolveAnnotatedTagRequest.Builder requestBuilder, @Nonnull GitAnnotatedTagCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RpcResolveAnnotatedTagRequest request = this.prepareBuilder(repository, requestBuilder).build();
        AnnotatedTagsResponseObserver observer = new AnnotatedTagsResponseObserver(callback, this.i18nService, repository);
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).resolveAnnotatedTags(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    @Nonnull
    public Branch resolveDefaultBranch(@Nonnull Repository repository, @Nonnull RpcResolveDefaultBranchRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcResolveDefaultBranchRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver responseObserver = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).resolveDefaultBranch(request, responseObserver);
        return RpcUtils.toBranch(((RpcResolveDefaultBranchResponse)responseObserver.asResult()).getBranch());
    }

    @Override
    @Nonnull
    public Map<String, Ref> resolveRefs(@Nonnull Repository repository, @Nonnull RpcResolveRefsRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcResolveRefsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver responseObserver = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).resolveRefs(request, responseObserver);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ((RpcResolveRefsResponse)responseObserver.asResult()).getResolvedRefsList().forEach(resolved -> {
            String refId = resolved.getRefId().toStringUtf8();
            switch (resolved.getRefOneofCase()) {
                case BRANCH: {
                    builder.put((Object)refId, (Object)RpcUtils.toBranch(resolved.getBranch()));
                    break;
                }
                case TAG: {
                    builder.put((Object)refId, (Object)RpcUtils.toTag(resolved.getTag()));
                }
            }
        });
        return builder.build();
    }

    @Override
    public void tags(@Nonnull Repository repository, @Nonnull RpcTagsRequest.Builder requestBuilder, @Nonnull TagCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        TagsResponseObserver observer = new TagsResponseObserver(callback, this.i18nService, repository);
        RpcTagsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).tags(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void updateRef(@Nonnull Repository repository, @Nonnull RpcUpdateRefRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcUpdateRefRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver responseObserver = new UnaryResponseObserver(new DeleteRefErrorTranslator(this.i18nService, repository));
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).updateRef(request, responseObserver);
        responseObserver.asResult();
    }

    @Override
    @Nonnull
    public List<MinimalRef> updateRefs(@Nonnull Repository repository, @Nonnull RpcUpdateRefsRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcUpdateRefsRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver responseObserver = new UnaryResponseObserver(new DeleteRefErrorTranslator(this.i18nService, repository));
        ((RefServiceGrpc.RefServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).updateRefs(request, responseObserver);
        RpcUpdateRefsResponse response = (RpcUpdateRefsResponse)responseObserver.asResult();
        return (List)response.getFailedRefIdsList().stream().map(ByteString::toStringUtf8).map(RpcUtils::toMinimalRef).collect(MoreCollectors.toImmutableList());
    }
}

