/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshRepositoryConsistencySummary;
import com.atlassian.bitbucket.dmz.mesh.RepositoryReplicaDetails;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RepositoryServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBulkVerifyRepositoryIntegrityRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBulkVerifyRepositoryIntegrityResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateRepositoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDeleteRepositoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFetchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetDefaultBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetDefaultBranchResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetRepositoryReplicaDetailsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetRepositoryReplicaDetailsResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetRepositorySizeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetRepositorySizeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcIsRepositoryEmptyRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcIsRepositoryEmptyResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcIsTranscodeEnabledRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcIsTranscodeEnabledResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPushRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepositoryConsistencySummary;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepositorySize;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcScheduleGarbageCollectionRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetDefaultBranchRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetGarbageCollectionPausedRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetGarbageCollectionPausedResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetMetadataRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetTranscodeEnabledRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcVerifyRepositoryConsistencyRequest;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.RepositorySize;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.integrity.IntegrityCheckCallback;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.scm.git.command.countobjects.SimpleRepositorySize;
import com.atlassian.stash.internal.scm.git.fetch.FetchCallback;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.FetchResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.PushResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryLoader;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.SetTranscodeEnabledErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.atlassian.stash.internal.scm.git.push.PushCallback;
import com.google.common.collect.Iterables;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Profiled
public class GrpcRepositoryClient
extends AbstractGrpcClient<RepositoryServiceGrpc.RepositoryServiceStub>
implements RpcRepositoryClient {
    public static final Duration DEADLINE_PADDING = Duration.ofSeconds(10L);
    private final Duration verifyConsistencyCheckTimeout;

    public GrpcRepositoryClient(I18nService i18nService, GitRequestHelper requestHelper, Duration verifyConsistencyCheckTimeout, MeshStub<RepositoryServiceGrpc.RepositoryServiceStub> stub) {
        super(i18nService, requestHelper, stub);
        this.verifyConsistencyCheckTimeout = verifyConsistencyCheckTimeout;
    }

    @Override
    public void bulkVerifyRepositoryIntegrity(@Nonnull MeshNode node, @Nonnull RpcRepositoryLoader repositoryLoader, @Nonnull RpcBulkVerifyRepositoryIntegrityRequest.Builder requestBuilder, @Nonnull IntegrityCheckCallback callback) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(repositoryLoader, "repositoryLoader");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        Objects.requireNonNull(callback, "callback");
        RpcBulkVerifyRepositoryIntegrityRequest request = this.prepareBuilder(requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, null));
        Duration deadline = Duration.ofHours(4L);
        this.requestHelper.applyTimeout((RepositoryServiceGrpc.RepositoryServiceStub)this.stub.forNode(node), deadline).bulkVerifyRepositoryIntegrity(request, observer);
        RpcBulkVerifyRepositoryIntegrityResponse response = (RpcBulkVerifyRepositoryIntegrityResponse)observer.asResult();
        response.getIntegrityIssuesList().forEach(issue -> {
            switch (issue.getIssueType()) {
                case INTEGRITY_ISSUE_MISSING_PRS: {
                    repositoryLoader.getRepository(issue.getRepository()).ifPresent(repository -> issue.getPullRequestIdsList().forEach(id -> callback.onMissingPullRequest(repository, id.longValue())));
                    break;
                }
                case INTEGRITY_ISSUE_EXTRA_PRS: {
                    repositoryLoader.getRepository(issue.getRepository()).ifPresent(repository -> issue.getPullRequestIdsList().forEach(id -> callback.onExtraPullRequest(repository, id.longValue())));
                }
            }
        });
    }

    @Override
    public void create(@Nonnull Repository repository, @Nonnull RpcCreateRepositoryRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcCreateRepositoryRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).create(request, observer);
        observer.asResult();
    }

    @Override
    public void delete(@Nonnull Repository repository, @Nonnull RpcDeleteRepositoryRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcDeleteRepositoryRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).delete(request, observer);
        observer.asResult();
    }

    @Override
    public void fetch(@Nonnull Repository repository, @Nonnull RpcFetchRequest.Builder requestBuilder, @Nonnull FetchCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        FetchResponseObserver observer = new FetchResponseObserver(callback, this.i18nService, repository);
        RpcFetchRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).fetch(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    @Nonnull
    public MinimalRef getDefaultBranch(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcGetDefaultBranchRequest request = this.prepareBuilder(repository, RpcGetDefaultBranchRequest.newBuilder()).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getDefaultBranch(request, observer);
        String branchId = ((RpcGetDefaultBranchResponse)observer.asResult()).getBranchId().toStringUtf8();
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(GitRefPattern.HEADS.unqualify(branchId))).id(branchId)).type((RefType)StandardRefType.BRANCH).build();
    }

    @Override
    @Nonnull
    public RepositoryReplicaDetails getReplicaDetails(@Nonnull MeshNode node, @Nonnull Repository repository) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(repository, "repository");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcGetRepositoryReplicaDetailsRequest request = this.prepareBuilder(repository, RpcGetRepositoryReplicaDetailsRequest.newBuilder()).build();
        this.requestHelper.applyTimeout((RepositoryServiceGrpc.RepositoryServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).getReplicaDetails(request, observer);
        return RpcUtils.toRepositoryReplicaDetails(((RpcGetRepositoryReplicaDetailsResponse)observer.asResult()).getDetails());
    }

    @Override
    @Nonnull
    public RepositorySize getSize(@Nonnull Repository repository, @Nonnull RpcGetRepositorySizeRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcGetRepositorySizeRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).getSize(request, observer);
        RpcGetRepositorySizeResponse response = (RpcGetRepositorySizeResponse)observer.asResult();
        RpcRepositorySize repositorySize = response.getSize();
        long garbageSize = repositorySize.getGarbageSize();
        long inPackSize = repositorySize.getInPackSize();
        long looseSize = repositorySize.getLooseSize();
        if (response.hasSharedSize() && repository.getOrigin() == null) {
            RpcRepositorySize sharedSize = response.getSharedSize();
            garbageSize += sharedSize.getGarbageSize();
            inPackSize += sharedSize.getInPackSize();
            looseSize += sharedSize.getLooseSize();
        }
        return new SimpleRepositorySize.Builder().garbageSize(garbageSize).inPackSize(inPackSize).looseSize(looseSize).build();
    }

    @Override
    public boolean isEmpty(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcIsRepositoryEmptyRequest request = this.prepareBuilder(repository, RpcIsRepositoryEmptyRequest.newBuilder()).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).isEmpty(request, observer);
        return ((RpcIsRepositoryEmptyResponse)observer.asResult()).getEmpty();
    }

    @Override
    public boolean isTranscodeEnabled(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcIsTranscodeEnabledRequest request = this.prepareBuilder(repository, RpcIsTranscodeEnabledRequest.newBuilder()).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).isTranscodeEnabled(request, observer);
        return ((RpcIsTranscodeEnabledResponse)observer.asResult()).getEnabled();
    }

    @Override
    public void push(@Nonnull Repository repository, @Nonnull RpcPushRequest.Builder requestBuilder, @Nonnull PushCallback callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        PushResponseObserver observer = new PushResponseObserver(callback, this.i18nService, repository);
        RpcPushRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).push(request, (StreamObserver)observer);
        observer.asResult();
    }

    @Override
    public void scheduleGarbageCollection(@Nonnull Repository repository, @Nonnull RpcScheduleGarbageCollectionRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        RpcScheduleGarbageCollectionRequest request = this.prepareBuilder(repository, requestBuilder).build();
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).scheduleGarbageCollection(request, observer);
        observer.asResult();
    }

    @Override
    public void setDefaultBranch(@Nonnull Repository repository, @Nonnull RpcSetDefaultBranchRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcSetDefaultBranchRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).setDefaultBranch(request, observer);
        observer.asResult();
    }

    @Override
    public boolean setGarbageCollectionPaused(@Nonnull Repository repository, @Nonnull RpcSetGarbageCollectionPausedRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcSetGarbageCollectionPausedRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        Duration timeout = request.getTimeout() > 0L ? Duration.ofSeconds(request.getTimeout()).plus(DEADLINE_PADDING) : null;
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request, timeout)).setGarbageCollectionPaused(request, observer);
        return ((RpcSetGarbageCollectionPausedResponse)observer.asResult()).getResult();
    }

    @Override
    public void setMetadata(@Nonnull Repository repository, @Nonnull RpcSetMetadataRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcSetMetadataRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).setMetadata(request, observer);
        observer.asResult();
    }

    @Override
    public void setTranscodeEnabled(@Nonnull Repository repository, @Nonnull RpcSetTranscodeEnabledRequest.Builder requestBuilder) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        RpcSetTranscodeEnabledRequest request = this.prepareBuilder(repository, requestBuilder).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new SetTranscodeEnabledErrorTranslator(this.i18nService, repository));
        ((RepositoryServiceGrpc.RepositoryServiceStub)this.getStubWithDeadline(repository, (MessageOrBuilder)request)).setTranscodeEnabled(request, observer);
        observer.asResult();
    }

    @Override
    @Nonnull
    public CompletableFuture<MeshRepositoryConsistencySummary> verifyConsistency(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Instant startTimestamp = Instant.now();
        RpcVerifyRepositoryConsistencyRequest request = this.prepareBuilder(repository, RpcVerifyRepositoryConsistencyRequest.newBuilder()).build();
        UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(this.i18nService, repository));
        this.requestHelper.applyTimeout((RepositoryServiceGrpc.RepositoryServiceStub)this.stub.forAnyReplica(repository), (MessageOrBuilder)request, this.verifyConsistencyCheckTimeout).verifyConsistency(request, observer);
        return observer.asFuture().thenApply(response -> GrpcRepositoryClient.toSummary(request.getRepository(), startTimestamp, response.getSummary()));
    }

    private static MeshRepositoryConsistencySummary toSummary(String repositoryId, Instant startTimestamp, RpcRepositoryConsistencySummary summary) {
        return new MeshRepositoryConsistencySummary.Builder(repositoryId, summary.getVersion()).consistentReplicas(Iterables.transform((Iterable)summary.getConsistentReplicasList(), Long::parseLong)).inconsistentReplicas(Iterables.transform((Iterable)summary.getInconsistentReplicasList(), Long::parseLong)).startTimestamp(startTimestamp).unavailableReplicas(Iterables.transform((Iterable)summary.getUnavailableReplicasList(), Long::parseLong)).build();
    }
}

