/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcApplyTransactionsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcApplyTransactionsResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.TransactionServiceGrpc;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.mesh.AbstractGrpcClient;
import com.atlassian.stash.internal.scm.git.mesh.ApplyTransactionsResult;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.RpcTransactionClient;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.google.protobuf.MessageOrBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class GrpcTransactionClient
extends AbstractGrpcClient<TransactionServiceGrpc.TransactionServiceStub>
implements RpcTransactionClient {
    public GrpcTransactionClient(I18nService i18nService, GitRequestHelper requestHelper, MeshStub<TransactionServiceGrpc.TransactionServiceStub> stub) {
        super(i18nService, requestHelper, stub);
    }

    @Override
    @Nonnull
    public ApplyTransactionsResult applyTransactions(@Nonnull MeshNode node, @Nonnull Repository repository, @Nonnull RpcApplyTransactionsRequest.Builder requestBuilder) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(requestBuilder, "requestBuilder");
        DefaultErrorTranslator errorTranslator = new DefaultErrorTranslator(this.i18nService, repository);
        RpcApplyTransactionsRequest request = this.prepareBuilder(requestBuilder).build();
        UnaryResponseObserver responseObserver = new UnaryResponseObserver(errorTranslator);
        this.requestHelper.applyTimeout((TransactionServiceGrpc.TransactionServiceStub)this.stub.forNode(node), (MessageOrBuilder)request, null).applyTransactions(request, responseObserver);
        RpcApplyTransactionsResponse response = (RpcApplyTransactionsResponse)responseObserver.asResult();
        return new ApplyTransactionsResult.Builder().exception(GrpcTransactionClient.maybeTranslate(response, errorTranslator)).unprocessedCount(request.getTransactionsCount() - response.getSuccessCount()).build();
    }

    private static RuntimeException maybeTranslate(RpcApplyTransactionsResponse response, DefaultErrorTranslator errorTranslator) {
        if (response.hasGitError()) {
            return errorTranslator.translate(response.getGitError(), null);
        }
        if (response.hasError()) {
            return errorTranslator.translate(response.getError(), null);
        }
        return null;
    }
}

