/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidTreeish;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class LastModifiedErrorTranslator
extends DefaultErrorTranslator {
    public LastModifiedErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    protected ServiceException translate(RpcGitError error, Throwable cause) {
        if (error.getErrorOneofCase() == RpcGitError.ErrorOneofCase.INVALID_TREEISH) {
            return this.translate(error.getInvalidTreeish());
        }
        return super.translate(error, cause);
    }

    private ArgumentValidationException translate(RpcInvalidTreeish error) {
        String treeish = error.getTreeish().toStringUtf8();
        String[] split = treeish.split(":");
        String commitId = split.length > 0 ? split[0] : "";
        String path = split.length > 1 ? split[1] : "";
        return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.lastmodified.pathnottree", new Object[]{path, commitId}));
    }
}

