/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.LastModifiedCallback;
import com.atlassian.bitbucket.commit.LastModifiedContext;
import com.atlassian.bitbucket.commit.LastModifiedSummary;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcLastModified;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcLastModifiedRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcLastModifiedResponseFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.LastModifiedErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

class LastModifiedResponseObserver
extends AbstractFutureResponseObserver<RpcLastModifiedRequest, RpcLastModifiedResponseFragment, Void> {
    private final LastModifiedCallback callback;
    private final I18nService i18nService;
    private final Repository repository;
    private final RpcLastModifiedRequest request;
    private volatile Commit latestCommit;
    private volatile ClientCallStreamObserver<RpcLastModifiedRequest> requestStream;
    private volatile boolean started;
    private volatile Throwable thrown;

    LastModifiedResponseObserver(@Nonnull LastModifiedCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull RpcLastModifiedRequest request) {
        super(new LastModifiedErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.request = Objects.requireNonNull(request, "request");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcLastModifiedRequest> requestStream) {
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.maybeFireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.maybeFireOnEnd(t));
    }

    public void onNext(RpcLastModifiedResponseFragment fragment) {
        this.maybeFireOnStart();
        switch (fragment.getFragmentOneofCase()) {
            case LATEST_COMMIT: {
                this.latestCommit = RpcUtils.toCommit(fragment.getLatestCommit(), this.repository);
                break;
            }
            case RESPONSE: {
                this.fireOnFiles(fragment.getResponse().getModificationsList());
                break;
            }
        }
    }

    private void fireOnFiles(List<RpcLastModified> modifications) {
        try {
            for (RpcLastModified modification : modifications) {
                Commit commit;
                String path = modification.getPath().toStringUtf8();
                if (this.callback.onFile(path, commit = RpcUtils.toCommit(modification.getCommit(), this.repository))) continue;
                this.requestStream.cancel("Canceled by callback", null);
                break;
            }
        }
        catch (IOException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable maybeFireOnEnd(Throwable thrown) {
        if (this.started) {
            try {
                this.callback.onEnd(new LastModifiedSummary.Builder(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED).latestCommit(this.latestCommit).build());
            }
            catch (IOException e) {
                if (thrown == null) {
                    thrown = this.wrapException(e);
                }
                thrown.addSuppressed(e);
            }
        }
        return thrown;
    }

    private void maybeFireOnStart() {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            this.callback.onStart(new LastModifiedContext.Builder(this.request.getCommitish().toStringUtf8()).path(ByteStringUtils.emptyToNull((ByteString)this.request.getPath())).build());
        }
        catch (IOException e) {
            throw this.wrapException(this.maybeFireOnEnd(e));
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

