/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.stash.internal.scm.git.mesh.MeshChannel;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;

public class LastSeenClientInterceptor
implements ClientInterceptor {
    private final MeshChannel channel;

    public LastSeenClientInterceptor(MeshChannel channel) {
        this.channel = channel;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final ClientCall delegate = next.newCall(method, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(delegate){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                delegate.start(new LastSeenClientListener(responseListener, LastSeenClientInterceptor.this.channel), headers);
            }
        };
    }

    private static class LastSeenClientListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final MeshChannel channel;

        LastSeenClientListener(ClientCall.Listener<RespT> delegate, MeshChannel channel) {
            super(delegate);
            this.channel = channel;
        }

        public void onClose(Status status, Metadata trailers) {
            super.onClose(status, trailers);
            if (status == Status.OK) {
                this.channel.touch();
            }
        }
    }
}

