/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeContext;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.ContentTreeSummary;
import com.atlassian.bitbucket.content.SimpleDirectory;
import com.atlassian.bitbucket.content.SimpleFile;
import com.atlassian.bitbucket.content.SimpleSubmodule;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDirectory;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFile;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcListDirectoryRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcListDirectoryResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcListDirectoryResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSubmodule;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.submodule.SubmoduleUrlBuilder;
import com.atlassian.stash.internal.scm.git.submodule.SubmoduleUrls;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;

class ListDirectoryResponseObserver
extends AbstractFutureResponseObserver<RpcListDirectoryRequest, RpcListDirectoryResponseFragment, Void> {
    private final ContentTreeCallback callback;
    private final I18nService i18nService;
    private final int limit;
    private final Repository repository;
    private final RpcListDirectoryRequest request;
    private final SubmoduleUrlBuilder urlBuilder;
    private volatile int count;
    private volatile ClientCallStreamObserver<RpcListDirectoryRequest> requestStream;
    private volatile Throwable thrown;

    ListDirectoryResponseObserver(@Nonnull ContentTreeCallback callback, @Nonnull I18nService i18nService, @Nonnull SubmoduleUrlBuilder urlBuilder, @Nonnull Repository repository, @Nonnull RpcListDirectoryRequest request) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.request = Objects.requireNonNull(request, "request");
        this.urlBuilder = Objects.requireNonNull(urlBuilder, "urlBuilder");
        this.limit = request.getLimit() - 1;
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcListDirectoryRequest> requestStream) {
        this.fireOnStart();
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcListDirectoryResponseFragment fragment) {
        try {
            for (RpcListDirectoryResponse response : fragment.getResponsesList()) {
                if (++this.count <= this.limit && this.fireOnTreeNode(response)) continue;
                this.requestStream.cancel("Canceled by callback", null);
                break;
            }
        }
        catch (IOException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            this.callback.onEnd(((ContentTreeSummary.Builder)((ContentTreeSummary.Builder)((ContentTreeSummary.Builder)new ContentTreeSummary.Builder(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED).lastPage(this.count <= this.limit)).pageRequest(PageUtils.newRequest((int)this.request.getSkip(), (int)this.limit))).size(Math.min(this.count, this.limit))).build());
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart(new ContentTreeContext.Builder(this.request.getCommitish().toStringUtf8()).recursive(this.request.getRecursive()).build());
        }
        catch (IOException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private boolean fireOnTreeNode(RpcListDirectoryResponse response) throws IOException {
        SimpleDirectory node;
        switch (response.getResponseOneofCase()) {
            case DIRECTORY: {
                RpcDirectory directory = response.getDirectory();
                node = new SimpleDirectory.Builder().contentId(directory.getContentId()).path(directory.getPath().toStringUtf8()).build();
                break;
            }
            case FILE: {
                RpcFile file = response.getFile();
                SimpleFile.Builder builder = new SimpleFile.Builder().contentId(file.getContentId()).path(file.getPath().toStringUtf8());
                if (file.hasSize()) {
                    builder.size(file.getSize());
                }
                node = builder.build();
                break;
            }
            case SUBMODULE: {
                RpcSubmodule submodule = response.getSubmodule();
                SubmoduleUrls urls = this.urlBuilder.build(this.repository, submodule.getUrl(), submodule.getContentId());
                node = new SimpleSubmodule.Builder().browseUrl(urls.getBrowseUrl()).contentId(submodule.getContentId()).path(submodule.getPath().toStringUtf8()).repositoryUrl(urls.getRepositoryUrl()).url(submodule.getUrl()).build();
                break;
            }
            default: {
                return true;
            }
        }
        return this.callback.onTreeNode((ContentTreeNode)node);
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

