/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import com.google.protobuf.MessageLite;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingClientInterceptor
implements ClientInterceptor {
    private static final int MAX_WIRE_LOG_LENGTH = 2048;
    private static final Logger log = LoggerFactory.getLogger(LoggingClientInterceptor.class);
    private static final Logger wireLog = LoggerFactory.getLogger((String)"bitbucket.grpc.wire-log");
    private final AtomicLong counter = new AtomicLong();
    private final boolean devProfileEnabled;
    private final int grpcMaxMessageSize;

    public LoggingClientInterceptor(boolean devProfileEnabled, int grpcMaxMessageSize) {
        this.devProfileEnabled = devProfileEnabled;
        this.grpcMaxMessageSize = grpcMaxMessageSize;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall delegate = next.newCall(method, callOptions);
        if ((!this.devProfileEnabled ? log.isTraceEnabled() : log.isDebugEnabled()) || wireLog.isTraceEnabled()) {
            MeshNode target = (MeshNode)callOptions.getOption(MeshConstants.OPT_TARGET_NODE);
            String methodName = method.getFullMethodName() + "@" + this.counter.incrementAndGet();
            if (target != null) {
                methodName = target.getName() + "/" + methodName;
            }
            return new LoggingClientCall(delegate, methodName, this.grpcMaxMessageSize);
        }
        return delegate;
    }

    private static class LoggingClientCall<ReqT, RespT>
    extends ForwardingClientCall<ReqT, RespT> {
        private final ClientCall<ReqT, RespT> delegate;
        private final int grpcMaxMessageSize;
        private final String methodName;

        LoggingClientCall(ClientCall<ReqT, RespT> delegate, String methodName, int grpcMaxMessageSize) {
            this.delegate = delegate;
            this.methodName = methodName;
            this.grpcMaxMessageSize = grpcMaxMessageSize;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            log.debug("[{}] --> start", (Object)this.methodName);
            wireLog.trace("[{}] --> start", (Object)this.methodName);
            super.start(new LoggingListener<RespT>(responseListener, this.methodName), headers);
        }

        public void sendMessage(ReqT message) {
            if (message instanceof MessageLite) {
                int serializedSize = ((MessageLite)message).getSerializedSize();
                if (serializedSize > this.grpcMaxMessageSize) {
                    log.warn("[{}] --> message size exceeded: {} > {}", new Object[]{this.methodName, serializedSize, this.grpcMaxMessageSize, log.isTraceEnabled() ? new IllegalArgumentException("Message size " + serializedSize + " is larger than the maximum message size " + this.grpcMaxMessageSize) : null});
                }
                log.debug("[{}] --> message sent (size {})", (Object)this.methodName, (Object)serializedSize);
                wireLog.trace("[{}] --> message sent (size {})", (Object)this.methodName, (Object)serializedSize);
            } else {
                log.debug("[{}] --> message sent (size unknown)", (Object)this.methodName);
                wireLog.trace("[{}] --> message sent (size unknown)", (Object)this.methodName);
            }
            if (wireLog.isTraceEnabled()) {
                String size;
                String messageText = String.valueOf(message);
                String string = size = message instanceof MessageLite ? String.valueOf(((MessageLite)message).getSerializedSize()) : "unknown size";
                if (!messageText.isEmpty()) {
                    wireLog.debug("[{}] --> SENT (size = {})\n{}", new Object[]{this.methodName, size, StringUtils.abbreviate((String)messageText, (int)2048)});
                }
            }
            super.sendMessage(message);
        }

        public void cancel(String message, Throwable cause) {
            log.debug("[{}] --> canceled with message: {}", (Object)this.methodName, (Object)message);
            wireLog.trace("[{}] --> canceled with message: {}", (Object)this.methodName, (Object)message);
            super.cancel(message, cause);
        }

        public void halfClose() {
            log.debug("[{}] --> sent onCompleted", (Object)this.methodName);
            wireLog.trace("[{}] --> sent onCompleted", (Object)this.methodName);
            super.halfClose();
        }

        protected ClientCall<ReqT, RespT> delegate() {
            return this.delegate;
        }
    }

    private static class LoggingListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final String methodName;

        LoggingListener(ClientCall.Listener<RespT> delegate, String methodName) {
            super(delegate);
            this.methodName = methodName;
        }

        public void onMessage(RespT message) {
            if (log.isDebugEnabled()) {
                if (message instanceof MessageLite) {
                    log.debug("[{}] <-- received a message (size = {})", (Object)this.methodName, (Object)((MessageLite)message).getSerializedSize());
                } else {
                    log.debug("[{}] <-- received a message (size unknown)", (Object)this.methodName);
                }
            }
            if (wireLog.isTraceEnabled()) {
                String size;
                String messageText = String.valueOf(message);
                String string = size = message instanceof MessageLite ? String.valueOf(((MessageLite)message).getSerializedSize()) : "unknown size";
                if (!messageText.isEmpty()) {
                    wireLog.trace("[{}] <-- RECEIVED (size = {})\n{}", new Object[]{this.methodName, size, StringUtils.abbreviate((String)messageText, (int)2048)});
                }
            }
            super.onMessage(message);
        }

        public void onHeaders(Metadata headers) {
            log.debug("[{}] <-- received headers", (Object)this.methodName);
            wireLog.trace("[{}] <-- received headers", (Object)this.methodName);
            super.onHeaders(headers);
        }

        public void onClose(Status status, Metadata trailers) {
            log.debug("[{}] <-- received onCompleted (status = {})", (Object)this.methodName, (Object)status.getCode());
            wireLog.trace("[{}] <-- received onCompleted (status = {})", (Object)this.methodName, (Object)status.getCode());
            super.onClose(status, trailers);
        }
    }
}

