/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.AddAddGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.AddRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ContentGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ConvergentDirectoryRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ConvergentRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DeleteModifyGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DeleteRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DirectoryFileGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DivergentDirectoryRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DivergentRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.FileDirectoryGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.GitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.GitMergeConflictType;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ImplicitDirectoryRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.MergedRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ModifyDeleteGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.RenameAddGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.RenameDeleteGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.SubmoduleGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.UnknownGitMergeConflict;
import com.google.common.base.Splitter;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeConflictTranslator {
    private static final Logger log = LoggerFactory.getLogger(MergeConflictTranslator.class);
    private static final Pattern PATTERN_ADDING_AS_INSTEAD = Pattern.compile("Adding as (.+) instead$");
    private static final Pattern PATTERN_ADDING_MERGED = Pattern.compile("Adding merged (.+)$");
    private static final Pattern PATTERN_AUTO_MERGING = Pattern.compile("Auto-merging (.+)$");
    private static final Pattern PATTERN_CONFLICT = Pattern.compile("CONFLICT \\(([^)]+)\\): (.+)$");
    private static final Pattern PATTERN_DELETED_AND_MODIFIED = Pattern.compile("(.+) deleted in (.+) and modified in (.+)\\.  ?Version (.+) of (.+) left in tree\\.?$");
    private static final Pattern PATTERN_DELETED_AND_RENAMED = Pattern.compile("(.+) deleted in (.+) and renamed in (.+)\\. Version (.+) of (.+) left in tree\\.?$");
    private static final Pattern PATTERN_DELETED_AND_RENAMED_TO = Pattern.compile("(.+) deleted in (.+) and renamed to (.+) in (.+)\\. Version (.+) of (.+) left in tree\\.?$");
    private static final Pattern PATTERN_DIRECTORY_HIDES_FILE_2_33 = Pattern.compile("There is a directory with name (.+) in (.+)\\. Adding (.+) as (.+)$");
    private static final Pattern PATTERN_DIRECTORY_HIDES_FILE_2_34 = Pattern.compile("directory in the way of (.+) from (.+); moving it to (.+) instead.$");
    private static final Pattern PATTERN_IMPLICIT_DIRECTORY_RENAME = Pattern.compile("Existing file/dir at (.+) in the way of implicit directory rename\\(s\\) putting the following path\\(s\\) there: (.+)\\.$");
    private static final Pattern PATTERN_IMPLICIT_DIRECTORY_RENAME_INTO_ONE = Pattern.compile("Cannot map more than one path to (.+); implicit directory renames tried to put these paths there: (.+)$");
    private static final Pattern PATTERN_MERGE = Pattern.compile("Merge conflict in (.+)$");
    private static final Pattern PATTERN_RENAMED_AND_ADDED_2_20 = Pattern.compile("Rename (.+)->(.+) in (.+)\\. (.+) added in (.+)$");
    private static final Pattern PATTERN_RENAMED_AND_ADDED_2_21 = Pattern.compile("Rename (.+)->(.+) in (.+)\\.  ?Added (.+) in (.+)$");
    private static final Pattern PATTERN_RENAMED_TO_AND_DELETED = Pattern.compile("(.+) renamed to (.+) in (.+), but deleted in (.+)\\.$");
    private static final Pattern PATTERN_RENAME_DIR_INTO_TWO = Pattern.compile("Rename directory (.+)->(.+) in (.+)\\. Rename directory (.+)->(.+) in (.+)$");
    private static final Pattern PATTERN_RENAME_INTO_ONE = Pattern.compile("Rename (.+)->(.+) in (.+)\\. Rename (.+)->(.+) in (.+)$");
    private static final Pattern PATTERN_RENAME_INTO_TWO_2_33 = Pattern.compile("Rename \"([^\"]+)\"->\"([^\"]+)\" in branch \"([^\"]+)\" rename \"([^\"]+)\"->\"([^\"]+)\" in \"([^\"]+)\"(?: \\(left unresolved\\))?$");
    private static final Pattern PATTERN_RENAME_INTO_TWO_2_34 = Pattern.compile("(.+) renamed to (.+) in (.+) and to (.+) in (.+)\\.$");
    private static final Pattern PATTERN_RENAME_PATHS = Pattern.compile("Renaming (.+) to (.+) and (.+) to (.+) instead$");
    private static final Pattern PATTERN_SPLIT_DIRECTORY_RENAME = Pattern.compile("Unclear where to place (.+) because directory (.+) was renamed to multiple other directories.+$");

    private MergeConflictTranslator() {
        throw new UnsupportedOperationException("Utility class can't be instantiated");
    }

    @Nonnull
    public static GitMergeConflict parseConflict(RpcMergeConflict conflict, Set<String> binaryPaths, String fromCommitId) {
        Matcher matcher = PATTERN_CONFLICT.matcher(conflict.getMessage());
        if (matcher.matches()) {
            String reason = matcher.group(1);
            String message = matcher.group(2);
            GitMergeConflictType type = GitMergeConflictType.fromReason((String)reason);
            try {
                switch (type) {
                    case ADD_ADD: {
                        return MergeConflictTranslator.parseAddConflict(type, message, binaryPaths);
                    }
                    case CONTENT: {
                        return MergeConflictTranslator.parseContentConflict(type, message, binaryPaths);
                    }
                    case DIRECTORY_FILE: 
                    case FILE_DIRECTORY: {
                        return MergeConflictTranslator.parseDirectoryFileConflict(type, message, fromCommitId);
                    }
                    case DELETE_MODIFY: 
                    case MODIFY_DELETE: {
                        return MergeConflictTranslator.parseModifyDeleteConflict(type, message, fromCommitId);
                    }
                    case IMPLICIT_DIRECTORY_RENAME: {
                        return MergeConflictTranslator.parseImplicitRenameConflict(type, message);
                    }
                    case RENAME_ADD: {
                        return MergeConflictTranslator.parseRenameAddConflict(type, message, (List<String>)conflict.getMoreMessagesList(), fromCommitId);
                    }
                    case RENAME_DELETE: {
                        return MergeConflictTranslator.parseRenameDeleteConflict(type, message, fromCommitId);
                    }
                    case RENAME_RENAME: {
                        return MergeConflictTranslator.parseRenameConflict(type, message, (List<String>)conflict.getMoreMessagesList(), fromCommitId);
                    }
                    case SPLIT_DIRECTORY_RENAME: {
                        return MergeConflictTranslator.parseSplitDirectoryRename(type, message);
                    }
                    case SUBMODULE: {
                        return MergeConflictTranslator.parseSubmoduleConflict(type, message);
                    }
                }
                return new UnknownGitMergeConflict(reason, message);
            }
            catch (IllegalStateException e) {
                log.debug("Unable to parse MergeConflict: {}", (Object)conflict, (Object)e);
                return new UnknownGitMergeConflict(reason, message);
            }
        }
        log.debug("Unable to parse MergeConflict that doesn't have a CONFLICT message: {}", (Object)conflict);
        return new UnknownGitMergeConflict(GitMergeConflictType.UNKNOWN.name(), conflict.getMessage());
    }

    private static String assembleMessage(String ... messages) {
        return StringUtils.join((Object[])messages, (String)"\\\n");
    }

    private static String autoMerging(String path) {
        return "Auto-merging " + path;
    }

    private static boolean isHead(Matcher matcher, int group) {
        return "HEAD".equals(matcher.group(group));
    }

    private static boolean isFromCommit(Matcher matcher, int group, String fromCommitId) {
        if (fromCommitId != null) {
            return fromCommitId.equals(matcher.group(group));
        }
        return false;
    }

    private static GitMergeConflict parseAddConflict(GitMergeConflictType type, String message, Set<String> binaryPaths) {
        Matcher matcher = MergeConflictTranslator.requiredMatch(PATTERN_MERGE, type, message);
        String path = matcher.group(1);
        return new AddAddGitMergeConflict(message, path, binaryPaths.contains(path));
    }

    private static ContentGitMergeConflict parseContentConflict(GitMergeConflictType type, String message, Set<String> binaryPaths) {
        Matcher matcher = MergeConflictTranslator.requiredMatch(PATTERN_MERGE, type, message);
        String path = matcher.group(1);
        return new ContentGitMergeConflict(message, path, binaryPaths.contains(path));
    }

    private static GitMergeConflict parseConvergentRenameConflict(String message, Matcher matcher, Matcher pathMatcher, String fromCommitId) {
        int theirBaseIndex;
        int ourBaseIndex;
        if (MergeConflictTranslator.isHead(matcher, 3) || MergeConflictTranslator.isFromCommit(matcher, 6, fromCommitId)) {
            ourBaseIndex = 1;
            theirBaseIndex = 3;
        } else if (MergeConflictTranslator.isHead(matcher, 6) || MergeConflictTranslator.isFromCommit(matcher, 3, fromCommitId)) {
            ourBaseIndex = 3;
            theirBaseIndex = 1;
        } else {
            throw MergeConflictTranslator.unknownHeadBranch(matcher, 3, 6);
        }
        if (!StringUtils.equals((CharSequence)matcher.group(1), (CharSequence)pathMatcher.group(1))) {
            throw new IllegalStateException("While parsing convergent renames, source paths [" + matcher.group(1) + "] and [" + pathMatcher.group(1) + "] do not match (LHS)");
        }
        if (!StringUtils.equals((CharSequence)matcher.group(4), (CharSequence)pathMatcher.group(3))) {
            throw new IllegalStateException("While parsing convergent renames, source paths [" + matcher.group(4) + "] and [" + pathMatcher.group(3) + "] do not match (RHS)");
        }
        return new ConvergentRenameGitMergeConflict(message, matcher.group(2), pathMatcher.group(ourBaseIndex), pathMatcher.group(ourBaseIndex + 1), pathMatcher.group(theirBaseIndex), pathMatcher.group(theirBaseIndex + 1));
    }

    private static GitMergeConflict parseDeletedAndRenamedConflict(String message, Matcher matcher) {
        String path = matcher.group(1);
        if (MergeConflictTranslator.isHead(matcher, 2)) {
            return new DeleteRenameGitMergeConflict(message, path);
        }
        if (MergeConflictTranslator.isHead(matcher, 3)) {
            return new RenameDeleteGitMergeConflict(message, path);
        }
        throw MergeConflictTranslator.unknownHeadBranch(matcher, 2, 3);
    }

    private static GitMergeConflict parseDeletedAndRenamedToConflict(String message, Matcher matcher) {
        String srcPath = matcher.group(1);
        String path = matcher.group(3);
        if (MergeConflictTranslator.isHead(matcher, 2)) {
            return new DeleteRenameGitMergeConflict(message, path, srcPath);
        }
        if (MergeConflictTranslator.isHead(matcher, 4)) {
            return new RenameDeleteGitMergeConflict(message, path, srcPath);
        }
        throw MergeConflictTranslator.unknownHeadBranch(matcher, 2, 4);
    }

    private static GitMergeConflict parseDirectoryFileConflict(GitMergeConflictType type, String message, String fromCommitId) {
        String pathCheck;
        Matcher matcher = PATTERN_DIRECTORY_HIDES_FILE_2_33.matcher(message);
        if (!matcher.matches()) {
            matcher = MergeConflictTranslator.requiredMatch(PATTERN_DIRECTORY_HIDES_FILE_2_34, type, message);
        }
        int groupCount = matcher.groupCount();
        String path = matcher.group(1);
        if (groupCount == 4 && !StringUtils.equals((CharSequence)path, (CharSequence)(pathCheck = matcher.group(3)))) {
            throw new IllegalStateException("While parsing directory/file conflict, paths [" + path + "] and [" + pathCheck + "] do not match");
        }
        String tmpPath = matcher.group(groupCount);
        if (MergeConflictTranslator.isHead(matcher, 2) || !MergeConflictTranslator.isFromCommit(matcher, 2, fromCommitId)) {
            return new DirectoryFileGitMergeConflict(message, path, tmpPath);
        }
        return new FileDirectoryGitMergeConflict(message, path, tmpPath);
    }

    private static GitMergeConflict parseDivergentRenameConflict(String message, Matcher matcher, String fromCommitId) {
        String srcPathCheck;
        int theirPathIndex;
        int ourPathIndex;
        int groupCount = matcher.groupCount();
        if (MergeConflictTranslator.isHead(matcher, 3) || MergeConflictTranslator.isFromCommit(matcher, groupCount, fromCommitId)) {
            ourPathIndex = 2;
            theirPathIndex = groupCount - 1;
        } else if (MergeConflictTranslator.isHead(matcher, groupCount) || MergeConflictTranslator.isFromCommit(matcher, 3, fromCommitId)) {
            ourPathIndex = groupCount - 1;
            theirPathIndex = 2;
        } else {
            throw MergeConflictTranslator.unknownHeadBranch(matcher, 3, groupCount);
        }
        String srcPath = matcher.group(1);
        if (groupCount == 6 && !StringUtils.equals((CharSequence)srcPath, (CharSequence)(srcPathCheck = matcher.group(4)))) {
            throw new IllegalStateException("While parsing divergent rename, source paths [" + srcPath + "] and [" + srcPathCheck + "] do not match");
        }
        return new DivergentRenameGitMergeConflict(message, srcPath, matcher.group(ourPathIndex), matcher.group(theirPathIndex));
    }

    private static GitMergeConflict parseImplicitRenameConflict(GitMergeConflictType type, String message) {
        Matcher matcher = PATTERN_IMPLICIT_DIRECTORY_RENAME.matcher(message);
        if (matcher.matches()) {
            List srcPaths = Splitter.on((String)", ").splitToList((CharSequence)matcher.group(2));
            return new ImplicitDirectoryRenameGitMergeConflict(message, matcher.group(1), srcPaths);
        }
        matcher = MergeConflictTranslator.requiredMatch(PATTERN_IMPLICIT_DIRECTORY_RENAME_INTO_ONE, type, message);
        List srcPaths = Splitter.on((String)", ").splitToList((CharSequence)matcher.group(2));
        return new ConvergentDirectoryRenameGitMergeConflict(message, matcher.group(1), srcPaths);
    }

    private static GitMergeConflict parseMergedRenameConflict(String message, Matcher matcher, String fromCommitId) {
        if (MergeConflictTranslator.isHead(matcher, 3) || MergeConflictTranslator.isFromCommit(matcher, 6, fromCommitId)) {
            return new MergedRenameGitMergeConflict(message, matcher.group(2), matcher.group(1), matcher.group(4));
        }
        if (MergeConflictTranslator.isHead(matcher, 6) || MergeConflictTranslator.isFromCommit(matcher, 3, fromCommitId)) {
            return new MergedRenameGitMergeConflict(message, matcher.group(2), matcher.group(4), matcher.group(1));
        }
        throw MergeConflictTranslator.unknownHeadBranch(matcher, 3, 6);
    }

    private static GitMergeConflict parseModifyDeleteConflict(GitMergeConflictType type, String message, String fromCommitId) {
        Matcher matcher = MergeConflictTranslator.requiredMatch(PATTERN_DELETED_AND_MODIFIED, type, message);
        String path = matcher.group(1);
        if (MergeConflictTranslator.isHead(matcher, 2) || MergeConflictTranslator.isFromCommit(matcher, 3, fromCommitId)) {
            return new DeleteModifyGitMergeConflict(message, path);
        }
        if (MergeConflictTranslator.isHead(matcher, 3) || MergeConflictTranslator.isFromCommit(matcher, 2, fromCommitId)) {
            return new ModifyDeleteGitMergeConflict(message, path);
        }
        throw MergeConflictTranslator.unknownHeadBranch(matcher, 2, 3);
    }

    private static GitMergeConflict parseRenameAddConflict(GitMergeConflictType type, String message, List<String> messages, String fromCommitId) {
        Matcher matcher = PATTERN_RENAMED_AND_ADDED_2_20.matcher(message);
        if (matcher.matches()) {
            return MergeConflictTranslator.parseRenameAddConflictWithTempFiles(message, messages, matcher, fromCommitId);
        }
        return MergeConflictTranslator.parseRenameAddConflictMergedInPlace(message, messages, MergeConflictTranslator.requiredMatch(PATTERN_RENAMED_AND_ADDED_2_21, type, message), fromCommitId);
    }

    private static GitMergeConflict parseRenameAddConflictMergedInPlace(String message, List<String> messages, Matcher matcher, String fromCommitId) {
        String pathCheck;
        String path = matcher.group(2);
        if (!StringUtils.equals((CharSequence)path, (CharSequence)(pathCheck = matcher.group(4)))) {
            throw new IllegalStateException("While parsing rename/add conflict, the renamed path [" + path + "] and added path [" + pathCheck + "] do not match");
        }
        String line = messages.get(0);
        if (StringUtils.isEmpty((CharSequence)line)) {
            throw new IllegalStateException("While parsing rename/add conflict, auto-merging output was not found");
        }
        if (!PATTERN_AUTO_MERGING.matcher(line).matches()) {
            throw new IllegalStateException("While parsing rename/add conflict, auto-merging output [" + line + "] did not match the expected pattern");
        }
        message = MergeConflictTranslator.assembleMessage(message, line);
        String srcPath = matcher.group(1);
        if (MergeConflictTranslator.isHead(matcher, 3) || MergeConflictTranslator.isFromCommit(matcher, 5, fromCommitId)) {
            return new RenameAddGitMergeConflict(message, path, srcPath, null);
        }
        if (MergeConflictTranslator.isHead(matcher, 5) || MergeConflictTranslator.isFromCommit(matcher, 3, fromCommitId)) {
            return new AddRenameGitMergeConflict(message, path, srcPath, null);
        }
        throw MergeConflictTranslator.unknownHeadBranch(matcher, 3, 5);
    }

    private static GitMergeConflict parseRenameAddConflictWithTempFiles(String message, List<String> messages, Matcher matcher, String fromCommitId) {
        String tmpPath;
        String pathCheck;
        String path = matcher.group(2);
        if (!StringUtils.equals((CharSequence)path, (CharSequence)(pathCheck = matcher.group(4)))) {
            throw new IllegalStateException("While parsing rename/add conflict, the renamed path [" + path + "] and added path [" + pathCheck + "] do not match");
        }
        String line = messages.get(0);
        if (StringUtils.isEmpty((CharSequence)line)) {
            throw new IllegalStateException("While parsing rename/add conflict, detail output was not found");
        }
        Matcher pathMatcher = PATTERN_ADDING_AS_INSTEAD.matcher(line);
        if (pathMatcher.matches()) {
            tmpPath = pathMatcher.group(1);
        } else if (PATTERN_ADDING_MERGED.matcher(line).matches()) {
            tmpPath = null;
        } else {
            throw new IllegalStateException("While parsing rename/add conflict, adding as/merged output [" + line + "] did not match either possible pattern");
        }
        message = MergeConflictTranslator.assembleMessage(message, line);
        String srcPath = matcher.group(1);
        if (MergeConflictTranslator.isHead(matcher, 3) || MergeConflictTranslator.isFromCommit(matcher, 5, fromCommitId)) {
            return new RenameAddGitMergeConflict(message, path, srcPath, tmpPath);
        }
        if (MergeConflictTranslator.isHead(matcher, 5) || MergeConflictTranslator.isFromCommit(matcher, 3, fromCommitId)) {
            if (messages.size() > 1) {
                String merge = messages.get(1);
                if (MergeConflictTranslator.autoMerging(path).equals(merge)) {
                    message = MergeConflictTranslator.assembleMessage(message, merge);
                }
            }
            return new AddRenameGitMergeConflict(message, path, srcPath, tmpPath);
        }
        throw MergeConflictTranslator.unknownHeadBranch(matcher, 3, 5);
    }

    private static GitMergeConflict parseRenameConflict(GitMergeConflictType type, String message, List<String> messages, String fromCommitId) {
        String pathCheck;
        Matcher matcher = PATTERN_RENAME_INTO_TWO_2_33.matcher(message);
        if (!matcher.matches() && !(matcher = PATTERN_RENAME_INTO_TWO_2_34.matcher(message)).matches()) {
            matcher = PATTERN_RENAME_DIR_INTO_TWO.matcher(message);
        }
        if (matcher.matches()) {
            return MergeConflictTranslator.parseDivergentRenameConflict(message, matcher, fromCommitId);
        }
        matcher = MergeConflictTranslator.requiredMatch(PATTERN_RENAME_INTO_ONE, type, message);
        String path = matcher.group(2);
        if (!StringUtils.equals((CharSequence)path, (CharSequence)(pathCheck = matcher.group(5)))) {
            throw new IllegalStateException("While parsing convergent rename, destination paths [" + path + "] and [" + pathCheck + "] do not match");
        }
        String line = messages.get(0);
        if (StringUtils.isEmpty((CharSequence)line)) {
            throw new IllegalStateException("While parsing convergent rename, path output was not found");
        }
        Matcher pathMatcher = PATTERN_RENAME_PATHS.matcher(line);
        if (pathMatcher.matches()) {
            return MergeConflictTranslator.parseConvergentRenameConflict(MergeConflictTranslator.assembleMessage(message, line), matcher, pathMatcher, fromCommitId);
        }
        if (PATTERN_AUTO_MERGING.matcher(line).matches()) {
            return MergeConflictTranslator.parseMergedRenameConflict(MergeConflictTranslator.assembleMessage(message, line), matcher, fromCommitId);
        }
        throw new IllegalStateException("While parsing convergent rename, the second line [" + line + "] did not match the expected pattern");
    }

    private static GitMergeConflict parseRenameDeleteConflict(GitMergeConflictType type, String message, String fromCommitId) {
        Matcher matcher = PATTERN_DELETED_AND_RENAMED.matcher(message);
        if (matcher.matches()) {
            return MergeConflictTranslator.parseDeletedAndRenamedConflict(message, matcher);
        }
        matcher = PATTERN_DELETED_AND_RENAMED_TO.matcher(message);
        if (matcher.matches()) {
            return MergeConflictTranslator.parseDeletedAndRenamedToConflict(message, matcher);
        }
        return MergeConflictTranslator.parseRenamedToAndDeletedConflict(message, MergeConflictTranslator.requiredMatch(PATTERN_RENAMED_TO_AND_DELETED, type, message), fromCommitId);
    }

    private static GitMergeConflict parseRenamedToAndDeletedConflict(String message, Matcher matcher, String fromCommitId) {
        String srcPath = matcher.group(1);
        String path = matcher.group(2);
        if (MergeConflictTranslator.isHead(matcher, 3) || MergeConflictTranslator.isFromCommit(matcher, 4, fromCommitId)) {
            return new RenameDeleteGitMergeConflict(message, path, srcPath);
        }
        if (MergeConflictTranslator.isHead(matcher, 4) || MergeConflictTranslator.isFromCommit(matcher, 3, fromCommitId)) {
            return new DeleteRenameGitMergeConflict(message, path, srcPath);
        }
        throw MergeConflictTranslator.unknownHeadBranch(matcher, 3, 4);
    }

    private static GitMergeConflict parseSplitDirectoryRename(GitMergeConflictType type, String message) {
        Matcher matcher = MergeConflictTranslator.requiredMatch(PATTERN_SPLIT_DIRECTORY_RENAME, type, message);
        return new DivergentDirectoryRenameGitMergeConflict(message, matcher.group(2), matcher.group(1));
    }

    private static GitMergeConflict parseSubmoduleConflict(GitMergeConflictType type, String message) {
        Matcher matcher = MergeConflictTranslator.requiredMatch(PATTERN_MERGE, type, message);
        return new SubmoduleGitMergeConflict(message, matcher.group(1));
    }

    private static Matcher requiredMatch(Pattern pattern, GitMergeConflictType type, String message) {
        Matcher matcher = pattern.matcher(message);
        if (!matcher.matches()) {
            throw new IllegalStateException("Parsing message for [" + String.valueOf(type) + "] conflict, [" + message + "] did not match the expected pattern");
        }
        return matcher;
    }

    private static IllegalStateException unknownHeadBranch(Matcher matcher, int first, int second) {
        throw new IllegalStateException("Cannot choose \"our\" revision between branches [" + matcher.group(first) + "] and [" + matcher.group(second) + "]");
    }
}

