/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidMerge;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeConflicts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNonFastForwardMerge;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRebaseConflicted;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUnsupportedMergeStrategy;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.git.command.merge.GitEmptyRebaseBeforeMergeException;
import com.atlassian.bitbucket.scm.git.command.merge.GitEmptySquashException;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeException;
import com.atlassian.bitbucket.scm.git.command.merge.GitNonFastForwardMergeRejectedException;
import com.atlassian.bitbucket.scm.git.command.merge.GitRebaseBeforeMergeConflictedException;
import com.atlassian.bitbucket.scm.git.command.merge.GitUnsupportedMergeStrategyException;
import com.atlassian.bitbucket.scm.git.command.push.GitNonFastForwardUpdateRejectedException;
import com.atlassian.bitbucket.scm.git.command.rebase.GitRebaseException;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.SigningErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeErrorTranslator
extends SigningErrorTranslator {
    private static final Logger log = LoggerFactory.getLogger(MergeErrorTranslator.class);
    private final String fromBranch;
    private final Repository fromRepository;
    private final String toBranch;

    MergeErrorTranslator(@Nonnull I18nService i18nService, @Nonnull Repository toRepository, @Nullable Repository fromRepository, @Nonnull RpcMergeRequest request) {
        this(i18nService, toRepository, Objects.requireNonNull(request, "request").getToBranch().toStringUtf8(), fromRepository, request.getFromBranch().toStringUtf8());
    }

    MergeErrorTranslator(@Nonnull I18nService i18nService, @Nonnull Repository toRepository, @Nonnull String toBranch, @Nullable Repository fromRepository, @Nonnull String fromBranch) {
        super(i18nService, Objects.requireNonNull(toRepository, "toRepository"));
        this.fromBranch = Objects.requireNonNull(fromBranch, "fromBranch");
        this.fromRepository = fromRepository;
        this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
    }

    @Nonnull
    public MergeException translateMergeConflicts(RpcMergeConflicts mergeConflicts) {
        GitMergeException cause = new GitMergeException(this.i18nService.createKeyedMessage("bitbucket.git.merge.conflict", new Object[0]), RpcUtils.toMergeConflicts(mergeConflicts));
        return this.newMergeException((Throwable)cause, mergeConflicts.getFromCommitId());
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case EMPTY_REBASE_MERGE: {
                return this.translateEmptyRebaseMerge();
            }
            case EMPTY_SQUASH_MERGE: {
                return this.translateEmptySquashMerge();
            }
            case INVALID_MERGE: {
                return this.translateInvalidMerge(error.getInvalidMerge());
            }
            case NON_FAST_FORWARD_MERGE: {
                return this.translateNonFastForwardMerge(error.getNonFastForwardMerge());
            }
            case NON_FAST_FORWARD_UPDATE: {
                return this.translateNonFastForwardUpdate();
            }
            case REBASE_CONFLICTED: {
                return this.translateRebaseConflicted(error.getRebaseConflicted());
            }
            case UNSUPPORTED_MERGE_STRATEGY: {
                return this.translateUnsupportedMergeStrategy(error.getUnsupportedMergeStrategy());
            }
            case WORK_TREE_WRITE_FAILED: {
                return this.translateWorkTreeWriteFailed(cause);
            }
        }
        return super.translate(error, cause);
    }

    private boolean isCrossRepository() {
        return Objects.equals(this.repository, this.fromRepository);
    }

    private MergeException newMergeException(Throwable cause, String fromCommitId) {
        KeyedMessage message = this.isCrossRepository() ? this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.interrepository", new Object[]{this.fromRepository.getProject().getKey(), this.fromRepository.getSlug(), this.repository.getProject().getKey(), this.repository.getSlug(), this.fromBranch, fromCommitId, this.toBranch}) : this.i18nService.createKeyedMessage("bitbucket.git.merge.failed.intrarepository", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.fromBranch, fromCommitId, this.toBranch});
        return this.newMergeException(message, cause);
    }

    private MergeException newMergeException(KeyedMessage message, Throwable cause) {
        boolean conflicted = cause instanceof GitMergeException && !((GitMergeException)cause).getConflicts().isEmpty();
        return new MergeException(message, cause, "git", this.repository, this.fromBranch, this.toBranch, conflicted);
    }

    private MergeException translateEmptyRebaseMerge() {
        return this.newMergeException(this.i18nService.createKeyedMessage("bitbucket.git.merge.rejected.rebase", new Object[0]), (Throwable)new GitEmptyRebaseBeforeMergeException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.uptodate", new Object[0])));
    }

    private MergeException translateEmptySquashMerge() {
        return this.newMergeException(this.i18nService.createKeyedMessage("bitbucket.git.merge.rejected.squash", new Object[0]), (Throwable)new GitEmptySquashException(this.i18nService.createKeyedMessage("bitbucket.git.squash.uptodate", new Object[0])));
    }

    private ArgumentValidationException translateInvalidMerge(RpcInvalidMerge error) {
        switch (error.getReason()) {
            default: {
                log.warn("Unexpected InvalidMerge error: {}", (Object)error.getReason());
            }
            case AUTHOR_EMAIL_BLANK: {
                return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.merge.request.invalid.author.email", new Object[0]));
            }
            case AUTHOR_NAME_BLANK: {
                return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.merge.request.invalid.author.name", new Object[0]));
            }
            case COMMIT_MESSAGE_BLANK: 
        }
        return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.merge.request.invalid.commit.message", new Object[0]));
    }

    private MergeException translateNonFastForwardMerge(RpcNonFastForwardMerge error) {
        GitNonFastForwardMergeRejectedException cause = new GitNonFastForwardMergeRejectedException(this.i18nService.createKeyedMessage("bitbucket.git.merge.rejected.nonfastforward", new Object[0]));
        return this.newMergeException((Throwable)cause, error.getFromCommitId());
    }

    private MergeException translateNonFastForwardUpdate() {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.git.merge.outofdate", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.toBranch});
        GitNonFastForwardUpdateRejectedException cause = new GitNonFastForwardUpdateRejectedException(this.i18nService.createKeyedMessage("bitbucket.git.merge.concurrent", new Object[0]), this.toBranch);
        return this.newMergeException(message, (Throwable)cause);
    }

    private MergeException translateRebaseConflicted(RpcRebaseConflicted error) {
        GitRebaseBeforeMergeConflictedException cause = new GitRebaseBeforeMergeConflictedException(this.i18nService.createKeyedMessage("bitbucket.git.merge.rebase.conflicted", new Object[0]), (Throwable)new GitRebaseException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.conflict", new Object[0])));
        return this.newMergeException((Throwable)cause, error.getFromCommitId());
    }

    private GitUnsupportedMergeStrategyException translateUnsupportedMergeStrategy(RpcUnsupportedMergeStrategy error) {
        return new GitUnsupportedMergeStrategyException(this.i18nService.createKeyedMessage("bitbucket.git.merge.unsupportedstrategy", new Object[]{error.getStrategyId(), error.getSupportedStrategiesList()}));
    }
}

