/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.util.concurrent.Gate;
import com.atlassian.stash.internal.mesh.MutableMeshNodeRegistry;
import com.atlassian.stash.internal.scm.git.mesh.LastSeenClientInterceptor;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.AbstractStub;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshChannel
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MeshChannel.class);
    private final ManagedChannel channel;
    private final MutableMeshNodeRegistry nodeRegistry;
    private final MeshNode node;
    private final Gate<Long> touchGate;
    private volatile ConnectivityState previousRegistryState;

    MeshChannel(@Nonnull MeshNode node, @Nonnull ManagedChannelBuilder<?> channelBuilder, @Nonnull MutableMeshNodeRegistry nodeRegistry) {
        this.nodeRegistry = Objects.requireNonNull(nodeRegistry, "nodeRegistry");
        this.node = Objects.requireNonNull(node, "node");
        this.channel = Objects.requireNonNull(channelBuilder, "channelBuilder").intercept(new ClientInterceptor[]{new LastSeenClientInterceptor(this)}).build();
        this.touchGate = new Gate(30L, TimeUnit.SECONDS);
        this.checkState();
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }

    public void closeNow() {
        this.channel.shutdownNow();
        try {
            if (!this.channel.awaitTermination(1L, TimeUnit.SECONDS)) {
                log.warn("{}: Channel was not shutdown within time limit. Channel might not be completely closed.", (Object)this);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("{}: Interrupted while waiting to shutdown. Channel might not be completely closed.", (Object)this, (Object)(log.isDebugEnabled() ? e : null));
        }
    }

    long getNodeId() {
        return this.node.getId();
    }

    @Nonnull
    public <S extends AbstractStub<S>> S newStub(@Nonnull Function<Channel, S> stubFactory) {
        return (S)((AbstractStub)Objects.requireNonNull(stubFactory, "stubFactory").apply((Channel)this.channel)).withOption(MeshConstants.OPT_TARGET_NODE, (Object)this.node);
    }

    public void refreshState() {
        this.channel.getState(true);
    }

    public void touch() {
        this.touchGate.callIfNotRecentlyRun((Object)this.node.getId(), () -> this.nodeRegistry.touchLastSeen(this.node));
    }

    public String toString() {
        return this.node.getName() + "#" + this.node.getId() + " (" + this.node.getRpcUrl() + ")";
    }

    private void checkState() {
        ConnectivityState state = this.channel.getState(false);
        log.debug("{}: Connectivity state updated to {}", (Object)this, (Object)state);
        if (state != this.previousRegistryState) {
            switch (state) {
                case IDLE: {
                    this.nodeRegistry.reportIdle(this.node);
                    break;
                }
                case READY: {
                    this.nodeRegistry.setOnline(this.node, true);
                    this.previousRegistryState = state;
                    break;
                }
                case TRANSIENT_FAILURE: {
                    if (this.previousRegistryState != ConnectivityState.READY && this.previousRegistryState != null) break;
                    this.nodeRegistry.setOnline(this.node, false);
                    this.previousRegistryState = state;
                    break;
                }
            }
        }
        if (state != ConnectivityState.SHUTDOWN) {
            this.channel.notifyWhenStateChanged(state, this::checkState);
        }
    }
}

