/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.scm.git.mesh.MeshClient;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;

@Component
public class MeshHealthcheck
implements ScheduledJobSource {
    static final String JOB_NAME = MeshHealthcheck.class.getSimpleName();
    static final JobId JOB_ID = JobId.of((String)JOB_NAME);
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JOB_NAME);
    private static final String PROP_INTERVAL = "${plugin.bitbucket-git.mesh.grpc.client.healthcheck-interval:5m}";
    private static final Logger log = LoggerFactory.getLogger(MeshHealthcheck.class);
    private final long intervalMs;
    private final MeshClient meshClient;
    private final DmzMeshService meshService;
    private final EscalatedSecurityContext withSysadmin;

    @Autowired
    public MeshHealthcheck(MeshClient meshClient, DmzMeshService meshService, SecurityService securityService, @Value(value="${plugin.bitbucket-git.mesh.grpc.client.healthcheck-interval:5m}") @DurationUnit(value=ChronoUnit.MINUTES) Duration interval) {
        this(meshClient, meshService, securityService, Math.max(interval.toMillis(), TimeUnit.MINUTES.toMillis(1L)));
    }

    @VisibleForTesting
    MeshHealthcheck(MeshClient meshClient, DmzMeshService meshService, SecurityService securityService, long intervalMs) {
        this.intervalMs = intervalMs;
        this.meshClient = meshClient;
        this.meshService = meshService;
        this.withSysadmin = securityService.withPermission(Permission.SYS_ADMIN, "List Mesh nodes for healthcheck");
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, this::run);
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.intervalMs, (Date)new Date(System.currentTimeMillis() + this.intervalMs))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private JobRunnerResponse run(JobRunnerRequest request) {
        List nodes = (List)this.withSysadmin.call(() -> ((DmzMeshService)this.meshService).getMembers());
        if (nodes.isEmpty()) {
            log.debug("No Mesh nodes are connected");
        } else {
            for (MeshNode node : nodes) {
                try {
                    log.debug("{}: Sending heartbeat", (Object)node);
                    this.meshClient.sendHeartbeat(node);
                }
                catch (Exception e) {
                    log.warn("{}: Failed to send heartbeat", (Object)node, (Object)e);
                }
            }
        }
        return JobRunnerResponse.success();
    }
}

