/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DataStoreConfig;
import com.atlassian.bitbucket.dmz.server.DmzDataStoreService;
import com.atlassian.bitbucket.mesh.util.KeyUtils;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.scm.git.mesh.SidecarProperties;
import com.atlassian.stash.internal.throttle.AdaptiveThrottlingMemoryEstimator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.atlassian.util.concurrent.LazyReference;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

@Component
public class MeshLauncher
implements ServletContextAware {
    static final Map<String, String> SHARED_PROPERTIES = ImmutableMap.of((Object)"plugin.bitbucket-git.path.executable", (Object)"git.path.executable", (Object)"plugin.bitbucket-git.mesh.grpc.zero-copy", (Object)"grpc.zero-copy", (Object)"plugin.bitbucket-git.mesh.sidecar.authentication.enabled", (Object)"authentication.enabled", (Object)"plugin.bitbucket-git.mesh.sidecar.jmx.enabled", (Object)"jmx.enabled");
    private static final Logger log = LoggerFactory.getLogger(MeshLauncher.class);
    private final AdaptiveThrottlingMemoryEstimator adaptiveThrottlingMemoryEstimator;
    private final DmzDataStoreService dataStoreService;
    private final Environment environment;
    private final HomeLayout homeLayout;
    private final MeshKeyManager keyManager;
    private final LazyReference<Integer> port;
    private final SidecarProperties sidecarProperties;
    private final EscalatedSecurityContext withSysAdmin;
    private volatile Path homeDir;
    private String webInf;

    @Autowired
    public MeshLauncher(AdaptiveThrottlingMemoryEstimator adaptiveThrottlingMemoryEstimator, DmzDataStoreService dataStoreService, Environment environment, HomeLayout homeLayout, MeshKeyManager keyManager, SecurityService securityService, SidecarProperties sidecarProperties) {
        this.adaptiveThrottlingMemoryEstimator = adaptiveThrottlingMemoryEstimator;
        this.dataStoreService = dataStoreService;
        this.environment = environment;
        this.homeLayout = homeLayout;
        this.keyManager = keyManager;
        this.sidecarProperties = sidecarProperties;
        this.port = new SidecarPortSupplier();
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "Retrieve data stores to launch sidecar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Path getHomeDir() {
        if (this.homeDir == null) {
            MeshLauncher meshLauncher = this;
            synchronized (meshLauncher) {
                if (this.homeDir == null) {
                    this.homeDir = MoreFiles.mkdir((Path)this.homeLayout.getHomeDir(), (String)"mesh");
                }
            }
        }
        return this.homeDir;
    }

    public int getSidecarPort() {
        return (Integer)this.port.get();
    }

    public void setServletContext(@Nonnull ServletContext servletContext) {
        this.webInf = servletContext.getRealPath("/WEB-INF");
    }

    @Nonnull
    Process start() throws IOException {
        int heapLimitMb;
        int heapSizeMb = this.sidecarProperties.getHeapSize();
        if (heapSizeMb > (heapLimitMb = this.sidecarProperties.getHeapLimit())) {
            log.info("Limiting sidecar memory to {} MB ({} MB was configured) because larger heaps lead to large garbage collection pauses.", (Object)heapLimitMb, (Object)heapSizeMb);
            heapSizeMb = heapLimitMb;
        }
        Path sharedHomeDir = this.homeLayout.getSharedHomeDir();
        Path homeDir = this.getHomeDir();
        Path configDir = MoreFiles.mkdir((Path)homeDir, (String)"config");
        KeyUtils.writePublicKey((Path)configDir.resolve("control-plane.pem"), (PublicKey)this.keyManager.getSigningKey().getPublic());
        KeyUtils.writeKeyPair((Path)configDir.resolve("signing-key.pem"), (KeyPair)this.keyManager.getSidecarKeys().toKeyPair());
        Path tempDir = MoreFiles.mkdir((Path)homeDir, (String)"tmp");
        String encoding = Charset.defaultCharset().name();
        ImmutableList.Builder argsBuilder = ImmutableList.builder().add((Object)MeshLauncher.getJavaBinary()).addAll(this.getDebuggerArgs()).add((Object)("-Xms" + heapSizeMb + "m")).add((Object)("-Xmx" + heapSizeMb + "m")).add((Object)"-XX:+UseG1GC").add((Object)("-Dfile.encoding=" + encoding)).add((Object)("-Dsun.jnu.encoding=" + encoding)).add((Object)("-Djava.io.tmpdir=" + String.valueOf(tempDir))).add((Object)("-Dlayout.caches-dir=" + String.valueOf(this.homeLayout.getCacheDir()))).add((Object)("-Dbitbucket.shared-home=" + String.valueOf(sharedHomeDir))).add((Object)"-Dgrpc.server.address").add((Object)("-Dgrpc.server.port=" + this.getSidecarPort())).add((Object)("-Dmesh.home=" + String.valueOf(homeDir))).add((Object)"-Dsidecar.child.process").add((Object)"-Dspring.profiles.active=sidecar").add((Object)("-Dthrottle.resource.scm-hosting.adaptive.mem.reserved=" + this.getReservedMemory())).addAll(this.getDataStoreArgs()).addAll(this.getSharedProperties().iterator()).addAll(this.sidecarProperties.getJvmArgs()).add((Object[])new String[]{"-jar", this.webInf + "/mesh/mesh-app.jar"});
        return new ProcessBuilder(new String[0]).command((List<String>)argsBuilder.build()).directory(homeDir.toFile()).redirectErrorStream(true).start();
    }

    private static String getJavaBinary() {
        Object javaBinary = "java";
        if (SystemUtils.IS_OS_WINDOWS) {
            javaBinary = (String)javaBinary + ".exe";
        }
        return MoreFiles.resolve((Path)Paths.get(System.getProperty("java.home"), new String[0]), (String)"bin", (String[])new String[]{javaBinary}).toAbsolutePath().toString();
    }

    private List<String> getDataStoreArgs() {
        return (List)this.withSysAdmin.call(() -> {
            DataStoreConfig config = this.dataStoreService.getConfig();
            DataStore sharedHome = config.getSharedHome();
            ImmutableList.Builder builder = ImmutableList.builder().add((Object)("-Dbitbucket.data-stores." + sharedHome.getId() + "=" + sharedHome.getPath()));
            for (DataStore dataStore : config.getAdditional()) {
                builder.add((Object)("-Dbitbucket.data-stores." + dataStore.getId() + "=" + dataStore.getPath()));
            }
            return builder.build();
        });
    }

    private List<String> getDebuggerArgs() {
        if (ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(arg -> arg.startsWith("-agentlib:jdwp="))) {
            Object address = "";
            int debugPort = this.sidecarProperties.getDebug().getPort();
            if (debugPort != -1) {
                address = ",address=" + debugPort;
                log.info("Starting sidecar in debug mode listening on port {}", (Object)debugPort);
            } else {
                log.info("Starting sidecar in debug mode. Check mesh-launcher.log for the debug port.");
            }
            return Collections.singletonList("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n" + (String)address);
        }
        return Collections.emptyList();
    }

    private long getReservedMemory() {
        return this.adaptiveThrottlingMemoryEstimator.getSearchMemoryReservedMemory() + this.adaptiveThrottlingMemoryEstimator.getWebappReservedMemory();
    }

    private Stream<String> getSharedProperties() {
        return SHARED_PROPERTIES.entrySet().stream().map(entry -> {
            String propertyValue = this.environment.getProperty((String)entry.getKey());
            return StringUtils.isBlank((CharSequence)propertyValue) ? null : "-D" + (String)entry.getValue() + "=" + propertyValue;
        }).filter(Objects::nonNull);
    }

    private class SidecarPortSupplier
    extends LazyReference<Integer> {
        private SidecarPortSupplier() {
        }

        @Nonnull
        protected Integer create() {
            Integer n;
            int defaultPort = MeshLauncher.this.sidecarProperties.getDefaultPort();
            ServerSocket socket2 = new ServerSocket(defaultPort, 1, InetAddress.getByName("localhost"));
            try {
                n = socket2.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException socket2) {
                    int port = this.findAvailablePort();
                    log.info("Starting sidecar on non-standard port {} because default port {} is not available", (Object)port, (Object)MeshLauncher.this.sidecarProperties.getDefaultPort());
                    return port;
                }
            }
            socket2.close();
            return n;
        }

        private int findAvailablePort() {
            int n;
            ServerSocket socket = new ServerSocket(0, 1, InetAddress.getByName("localhost"));
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            socket.close();
            return n;
        }
    }
}

