/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshConfigProvider;
import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.profiling.ProfilingService;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;

public class MeshNodeLoggingConfigProvider
implements MeshConfigProvider {
    private static final Map<String, String> DEBUG_LOG_LEVELS = ImmutableMap.builder().put((Object)"ROOT", (Object)"INFO").put((Object)"com.atlassian.bitbucket", (Object)"DEBUG").put((Object)"org.springframework", (Object)"INFO").build();
    private final LoggingService loggingService;
    private final ProfilingService profilingService;
    private final SecurityService securityService;

    public MeshNodeLoggingConfigProvider(LoggingService loggingService, ProfilingService profilingService, SecurityService securityService) {
        this.loggingService = loggingService;
        this.profilingService = profilingService;
        this.securityService = securityService;
    }

    public void mergeConfig(@Nonnull MeshConfigProvider.ConfigBuilder builder) {
        this.securityService.withPermission(Permission.SYS_ADMIN, "Retrieving whether debug logging and profiling are enabled for updating mesh node logging configuration").call(() -> {
            boolean isDebugLoggingEnabled = this.loggingService.isDebugLoggingEnabled();
            boolean isProfilingEnabled = this.profilingService.isProfilingEnabled();
            DEBUG_LOG_LEVELS.forEach((logger, level) -> builder.put("logging.logger." + logger, (Object)(isDebugLoggingEnabled ? level : null)));
            builder.put("profiling.enabled", (Object)(isProfilingEnabled ? Boolean.valueOf(true) : null));
            return null;
        });
    }
}

