/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshController;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.log.LoggingSettingsChangedEvent;
import com.atlassian.stash.internal.server.ProfilingSettingsChangedEvent;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;

public class MeshNodeLoggingEventListener {
    private static final String TOPIC_ID = "mesh.node.logging.event.listener";
    private final DmzMeshController controller;
    private final SecurityService securityService;
    private final Topic<Boolean> topic;
    private String topicSubscriptionId;

    public MeshNodeLoggingEventListener(DmzMeshController controller, SecurityService securityService, TopicService topicService) {
        this.controller = controller;
        this.securityService = securityService;
        this.topic = topicService.getTopic(TOPIC_ID, new TopicSettings.Builder(Boolean.class).dedupePendingMessages(true).queueSize(1).build());
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Reloading Mesh config via cluster rejoin event").call(() -> {
                this.apply();
                return null;
            });
        }
    }

    @EventListener
    public void onLoggingSettingsChangedEvent(LoggingSettingsChangedEvent ignored) {
        this.apply();
        this.topic.publish((Serializable)Boolean.TRUE);
    }

    @EventListener
    public void onProfilingSettingsChangedEvent(ProfilingSettingsChangedEvent ignored) {
        this.apply();
        this.topic.publish((Serializable)Boolean.TRUE);
    }

    @PostConstruct
    public void start() {
        this.topicSubscriptionId = this.topic.subscribe(message -> {
            if (!message.getSource().isLocal()) {
                this.securityService.withPermission(Permission.SYS_ADMIN, "Reloading Mesh config via topic message").call(() -> {
                    this.apply();
                    return null;
                });
            }
        });
    }

    @PreDestroy
    public void stop() {
        this.topic.unsubscribe(this.topicSubscriptionId);
    }

    private void apply() {
        this.controller.refreshConfiguration();
    }
}

