/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.stash.internal.scm.git.mesh.MeshProperty;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class MeshPropertyMapping {
    private final Map<String, MeshProperty> properties;

    private MeshPropertyMapping(Builder builder) {
        this.properties = builder.properties.build();
    }

    void forEach(@Nonnull BiConsumer<? super String, ? super MeshProperty> consumer) {
        this.properties.forEach(consumer);
    }

    @Nullable
    MeshProperty get(@Nonnull String name) {
        return this.properties.get(name);
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, MeshProperty> properties = ImmutableMap.builder();

        @Nonnull
        public Builder booleanProperty(@Nonnull String name) {
            return this.property(name, name, Boolean.class, false);
        }

        @Nonnull
        public Builder booleanProperty(@Nonnull String name, @Nonnull String meshName) {
            return this.property(name, meshName, Boolean.class, false);
        }

        @Nonnull
        public MeshPropertyMapping build() {
            return new MeshPropertyMapping(this);
        }

        @Nonnull
        public Builder doubleProperty(@Nonnull String name) {
            return this.property(name, name, Double.class, false);
        }

        @Nonnull
        public Builder doubleProperty(@Nonnull String name, boolean expression) {
            return this.property(name, name, Double.class, expression);
        }

        @Nonnull
        public Builder doubleProperty(@Nonnull String name, @Nonnull String meshName) {
            return this.property(name, meshName, Double.class, false);
        }

        @Nonnull
        public Builder doubleProperty(@Nonnull String name, @Nonnull String meshName, boolean expression) {
            return this.property(name, meshName, Double.class, expression);
        }

        @Nonnull
        public Builder intProperty(@Nonnull String name) {
            return this.property(name, name, Integer.class, false);
        }

        @Nonnull
        public Builder intProperty(@Nonnull String name, boolean expression) {
            return this.property(name, name, Integer.class, expression);
        }

        @Nonnull
        public Builder intProperty(@Nonnull String name, @Nonnull String meshName) {
            return this.property(name, meshName, Integer.class, false);
        }

        @Nonnull
        public Builder intProperty(@Nonnull String name, @Nonnull String meshName, boolean expression) {
            return this.property(name, meshName, Integer.class, expression);
        }

        @Nonnull
        public Builder longProperty(@Nonnull String name) {
            return this.property(name, name, Long.class, false);
        }

        @Nonnull
        public Builder longProperty(@Nonnull String name, boolean expression) {
            return this.property(name, name, Long.class, expression);
        }

        @Nonnull
        public Builder longProperty(@Nonnull String name, @Nonnull String meshName) {
            return this.property(name, meshName, Long.class, false);
        }

        @Nonnull
        public Builder longProperty(@Nonnull String name, @Nonnull String meshName, boolean expression) {
            return this.property(name, meshName, Long.class, expression);
        }

        @Nonnull
        public Builder stringProperty(@Nonnull String name) {
            return this.property(name, name, String.class, false);
        }

        @Nonnull
        public Builder stringProperty(@Nonnull String name, @Nonnull String meshName) {
            return this.property(name, meshName, String.class, false);
        }

        private Builder property(@Nonnull String name, @Nonnull String meshName, @Nonnull Class<?> type, boolean expressionSupported) {
            this.properties.put((Object)Objects.requireNonNull(name, "name"), (Object)new MeshProperty(Objects.requireNonNull(meshName, "meshName"), Objects.requireNonNull(type, "type"), expressionSupported));
            return this;
        }
    }
}

