/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.stash.internal.repository.RepositoryOfflineSupplier;
import com.atlassian.stash.internal.scm.git.mesh.SidecarNode;
import jakarta.annotation.Nonnull;

public class MeshRepositoryOfflineSupplier
implements RepositoryOfflineSupplier {
    private final DmzMeshPartitionRegistry partitionRegistry;
    private final SidecarNode sidecar;

    public MeshRepositoryOfflineSupplier(DmzMeshPartitionRegistry partitionRegistry, SidecarNode sidecar) {
        this.partitionRegistry = partitionRegistry;
        this.sidecar = sidecar;
    }

    public boolean isOffline(@Nonnull DmzRepository repository) {
        int partition = repository.getPartition();
        if (partition < 0) {
            return this.sidecar.isEnabled() && this.sidecar.isOffline();
        }
        return this.partitionRegistry.getPartition(partition).map(p -> !p.isAvailable()).orElse(true);
    }
}

