/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.MetadataKeys;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import com.atlassian.stash.internal.scm.git.mesh.MetadataProvider;
import com.google.common.collect.ImmutableList;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.List;

public class MetadataClientInterceptor
implements ClientInterceptor {
    private final List<MetadataProvider> providers;

    public MetadataClientInterceptor(MetadataProvider[] providers) {
        this.providers = ImmutableList.copyOf((Object[])providers);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall delegate = next.newCall(method, callOptions);
        if (this.providers.isEmpty()) {
            return delegate;
        }
        final Metadata metadata = new Metadata();
        for (MetadataProvider provider : this.providers) {
            provider.apply(metadata);
        }
        MeshNode targetNode = (MeshNode)callOptions.getOption(MeshConstants.OPT_TARGET_NODE);
        if (targetNode != null && !targetNode.isSidecar()) {
            metadata.put(MetadataKeys.KEY_TARGET_ID, (Object)Long.toString(targetNode.getId()));
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(this, delegate){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.merge(metadata);
                super.start(responseListener, headers);
            }
        };
    }
}

