/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublishWorkTreeFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublishWorkTreeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublishWorkTreeResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublishWorkTreeResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRunPublishWorkTreeHooks;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUpdateRef;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.bitbucket.scm.git.worktree.PublishGitWorkTreeParameters;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.worktree.MeshGitWorkTree;
import io.grpc.Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Objects;

public class PublishWorkTreeResponseObserver
extends AbstractFutureResponseObserver<RpcPublishWorkTreeFragment, RpcPublishWorkTreeResponseFragment, Void> {
    private final RpcPublishWorkTreeRequest request;
    private final PublishGitWorkTreeParameters parameters;
    private final GitRequestHelper requestHelper;
    private final MeshGitWorkTree workTree;

    public PublishWorkTreeResponseObserver(@Nullable ErrorTranslator errorTranslator, @Nonnull MeshGitWorkTree workTree, @Nonnull GitRequestHelper requestHelper, @Nonnull RpcPublishWorkTreeRequest request, @Nonnull PublishGitWorkTreeParameters parameters) {
        super(errorTranslator);
        this.request = Objects.requireNonNull(request, "request");
        this.parameters = Objects.requireNonNull(parameters, "parameters");
        this.requestHelper = Objects.requireNonNull(requestHelper, "requestHelper");
        this.workTree = Objects.requireNonNull(workTree, "workTree");
    }

    public void onNext(RpcPublishWorkTreeResponseFragment fragment) {
        try {
            switch (fragment.getRequestOneofCase()) {
                case RUN_HOOKS: {
                    this.runHooks(fragment.getRunHooks());
                    break;
                }
                case RESPONSE: {
                    this.handleResponse(fragment.getResponse());
                    break;
                }
                default: {
                    throw Status.UNIMPLEMENTED.withDescription("[" + String.valueOf(fragment.getRequestOneofCase()) + "] is not supported").asRuntimeException();
                }
            }
        }
        catch (RuntimeException e) {
            this.requestStream.onError((Throwable)e);
        }
    }

    @Override
    <E extends Throwable> Void asResult(@Nullable Class<E> exceptionClass) throws E {
        this.requestStream.onNext((Object)RpcPublishWorkTreeFragment.newBuilder().setRequest(this.request).build());
        return (Void)super.asResult(exceptionClass);
    }

    private void handleResponse(RpcPublishWorkTreeResponse response) {
        this.parameters.getHookInvoker().postUpdate((GitWorkTree)this.workTree, Collections.singletonList(RpcUtils.toRefChange(response.getRefUpdate())));
        this.requestStream.onCompleted();
    }

    private void runHooks(RpcRunPublishWorkTreeHooks runHooksResponse) {
        this.requestHelper.withQuarantine(this.workTree.getRepository(), this.workTree.getTargetNode(), runHooksResponse.getRepositoryId(), () -> {
            if (this.parameters.getHookInvoker().preUpdate((GitWorkTree)this.workTree, Collections.singletonList(RpcUtils.toRefChange(runHooksResponse.getRefUpdate())))) {
                this.requestStream.onNext((Object)RpcPublishWorkTreeFragment.newBuilder().setUpdateRef(RpcUpdateRef.getDefaultInstance()).build());
            } else {
                this.requestStream.onCompleted();
            }
        });
    }
}

