/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.ChangeSummary;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChange;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestChangesRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestChangesResponseFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

class PullRequestChangesResponseObserver
extends AbstractFutureResponseObserver<RpcGetPullRequestChangesRequest, RpcGetPullRequestChangesResponseFragment, Void> {
    private final AtomicInteger added;
    private final ChangeCallback callback;
    private final ChangeContext changeContext;
    private final I18nService i18nService;
    private volatile ClientCallStreamObserver<RpcGetPullRequestChangesRequest> requestStream;
    private volatile Throwable thrown;

    PullRequestChangesResponseObserver(@Nonnull ChangeCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull ChangeContext changeContext) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.changeContext = Objects.requireNonNull(changeContext, "changeContext");
        this.added = new AtomicInteger();
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcGetPullRequestChangesRequest> requestStream) {
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcGetPullRequestChangesResponseFragment fragment) {
        if (this.isCanceled() || this.thrown != null) {
            return;
        }
        try {
            for (RpcChange change : fragment.getChangesList()) {
                if (this.added.getAndIncrement() == 0) {
                    this.callback.onStart(this.changeContext);
                }
                if (this.callback.onChange(RpcUtils.toChange(change))) continue;
                this.cancel("Canceled by callback");
                break;
            }
        }
        catch (IOException | RuntimeException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            CommandResult result = this.isCanceled() ? CommandResult.CANCELED : (thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED);
            int count = this.added.get();
            if (count > 0) {
                this.callback.onEnd(new ChangeSummary.Builder(result).truncated(count > this.changeContext.getMaxChanges()).build());
            } else if (result == CommandResult.SUCCEEDED) {
                this.callback.onStart(this.changeContext);
                this.callback.onEnd(new ChangeSummary.Builder(CommandResult.SUCCEEDED).build());
            }
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

