/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetPullRequestCommitsResponseFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

class PullRequestCommitsResponseObserver
extends AbstractFutureResponseObserver<RpcGetPullRequestCommitsRequest, RpcGetPullRequestCommitsResponseFragment, Void> {
    private final AtomicInteger added;
    private final CommitCallback callback;
    private final I18nService i18nService;
    private final Repository repository;
    private volatile ClientCallStreamObserver<RpcGetPullRequestCommitsRequest> requestStream;
    private volatile Throwable thrown;

    PullRequestCommitsResponseObserver(@Nonnull CommitCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = callback;
        this.i18nService = i18nService;
        this.repository = repository;
        this.added = new AtomicInteger();
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcGetPullRequestCommitsRequest> requestStream) {
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcGetPullRequestCommitsResponseFragment fragment) {
        if (this.isCanceled() || this.thrown != null) {
            return;
        }
        try {
            for (RpcCommit commit : fragment.getCommitsList()) {
                if (this.added.getAndIncrement() == 0) {
                    this.callback.onStart(new CommitContext.Builder().build());
                }
                if (this.callback.onCommit(RpcUtils.toCommit(commit, this.repository))) continue;
                this.cancel("Canceled by callback");
                break;
            }
        }
        catch (IOException | RuntimeException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            CommandResult result;
            CommandResult commandResult = this.isCanceled() ? CommandResult.CANCELED : (result = thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED);
            if (this.added.get() > 0) {
                this.callback.onEnd(new CommitSummary.Builder(result).build());
            } else if (result == CommandResult.SUCCEEDED) {
                this.callback.onStart(new CommitContext.Builder().build());
                this.callback.onEnd(new CommitSummary.Builder(result).build());
            }
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

