/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.git.command.merge.GitNoCommonAncestorException;
import com.atlassian.stash.internal.scm.git.mesh.MergeErrorTranslator;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class PullRequestErrorTranslator
extends MergeErrorTranslator {
    private final PullRequest pullRequest;

    PullRequestErrorTranslator(@Nonnull I18nService i18nService, @Nonnull PullRequest pullRequest) {
        super(i18nService, Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository(), pullRequest.getToRef().getDisplayId(), pullRequest.getFromRef().getRepository(), pullRequest.getFromRef().getDisplayId());
        this.pullRequest = pullRequest;
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case NO_MERGE_BASE: {
                return new GitNoCommonAncestorException(this.i18nService.createKeyedMessage("bitbucket.git.pullrequest.merge.nocommonancestor", new Object[]{this.pullRequest.getFromRef().getDisplayId(), this.pullRequest.getToRef().getDisplayId(), this.pullRequest.getId(), this.repository.getProject().getKey(), this.repository.getSlug()}));
            }
            case DELETE_PULL_REQUEST_FAILED: {
                return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.pullrequest.delete.failed", new Object[]{this.pullRequest.getId(), this.repository.getProject().getKey(), this.repository.getSlug()}));
            }
        }
        return super.translate(error, cause);
    }
}

