/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AuthenticationFailedScmException;
import com.atlassian.bitbucket.scm.NotAuthorizedScmException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class PushErrorTranslator
extends DefaultErrorTranslator {
    PushErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case REMOTE_AUTHENTICATION_FAILED: {
                String remoteUrl = error.getRemoteAuthenticationFailed().getUrl();
                return new AuthenticationFailedScmException(this.i18nService.createKeyedMessage("bitbucket.git.remote.authenticationerror", new Object[]{remoteUrl}), "git");
            }
            case REMOTE_AUTHORIZATION_FAILED: {
                return new NotAuthorizedScmException(this.i18nService.createKeyedMessage("bitbucket.git.remote.authorizationerror", new Object[0]), "git");
            }
        }
        return super.translate(error, cause);
    }
}

