/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcProgressUpdate;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPushProgressFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPushRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPushResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPushResultFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefUpdate;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.PushErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.push.PushCallback;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushResponseObserver
extends AbstractFutureResponseObserver<RpcPushRequest, RpcPushResponseFragment, Void> {
    private static final Logger log = LoggerFactory.getLogger(PushResponseObserver.class);
    private final PushCallback callback;
    private final I18nService i18nService;
    private final Repository repository;
    private volatile Throwable thrown;

    public PushResponseObserver(PushCallback callback, I18nService i18nService, Repository repository) {
        super(new PushErrorTranslator(i18nService, repository));
        this.callback = callback;
        this.i18nService = i18nService;
        this.repository = repository;
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcPushRequest> requestStream) {
        this.fireOnStart();
        super.beforeStart(requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcPushResponseFragment fragment) {
        switch (fragment.getFragmentOneofCase()) {
            case RESULT: {
                this.handleResult(fragment.getResult());
                break;
            }
            case PROGRESS_UPDATE: {
                this.handleProgress(fragment.getProgressUpdate());
            }
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            this.callback.onEnd(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED);
        }
        catch (IOException e) {
            this.logCallbackException("onEnd", e);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart();
        }
        catch (IOException e) {
            this.logCallbackException("onStart", e);
        }
        catch (RuntimeException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private void handleProgress(RpcPushProgressFragment fragment) {
        for (RpcProgressUpdate progressUpdate : fragment.getProgressUpdatesList()) {
            try {
                this.callback.onProgress((Progress)new ProgressImpl(progressUpdate.getMessage(), progressUpdate.getPercentage()));
            }
            catch (IOException e) {
                this.logCallbackException("onProgress", e);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
        }
    }

    private void handleResult(RpcPushResultFragment fragment) {
        for (RpcRefUpdate refUpdate : fragment.getRefUpdatesList()) {
            try {
                this.callback.onRefChange(RpcUtils.toMinimalRefChange(refUpdate));
            }
            catch (IOException e) {
                this.logCallbackException("onRefChange", e);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
        }
        for (String refId : ByteStringUtils.toStringsLazily((List)fragment.getFailedRefIdsList())) {
            try {
                this.callback.onFailedRef(RpcUtils.toMinimalRef(refId));
            }
            catch (IOException e) {
                this.logCallbackException("onFailedRef", e);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
        }
    }

    private void handleRuntimeException(RuntimeException e) {
        if (this.thrown == null) {
            this.thrown = e;
        } else {
            this.thrown.addSuppressed(e);
        }
    }

    private void logCallbackException(String callbackName, IOException e) {
        if (log.isDebugEnabled()) {
            log.warn("{}: Error handling {} callback", new Object[]{this.repository, callbackName, e});
        } else {
            log.warn("{}: Error handling {} callback: {}", new Object[]{this.repository, callbackName, e.getMessage()});
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

