/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidRebase;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidRefName;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRebaseRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.push.GitNonFastForwardUpdateRejectedException;
import com.atlassian.bitbucket.scm.git.command.rebase.GitRebaseException;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RebaseErrorTranslator
extends DefaultErrorTranslator {
    private static final Logger log = LoggerFactory.getLogger(RebaseErrorTranslator.class);
    private final String branch;
    private final I18nService i18nService;
    private final Repository repository;

    RebaseErrorTranslator(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull RpcRebaseRequest request) {
        super(i18nService, repository);
        Objects.requireNonNull(request, "request");
        this.branch = Objects.requireNonNull(request.getBranch().toStringUtf8(), "branch");
        this.i18nService = i18nService;
        this.repository = Objects.requireNonNull(repository, "repository");
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case EMPTY_REBASE: {
                return this.translateEmptyRebase();
            }
            case INVALID_REBASE: {
                return this.translateInvalidRebase(error.getInvalidRebase());
            }
            case INVALID_REF_NAME: {
                return this.translateInvalidRefName(error.getInvalidRefName());
            }
            case NON_FAST_FORWARD_UPDATE: {
                return this.translateNonFastForwardUpdate();
            }
            case REBASE_CONFLICTED: {
                return this.translateRebaseConflicted();
            }
            case REBASE_FAILED: 
            case WORK_TREE_WRITE_FAILED: {
                return this.translateRebaseFailed(cause);
            }
        }
        return super.translate(error, cause);
    }

    protected ArgumentValidationException translateInvalidRefName(RpcInvalidRefName error) {
        return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.invalidupstream", new Object[]{error.getRefName()}));
    }

    private GitRebaseException translateEmptyRebase() {
        return new GitRebaseException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.uptodate", new Object[0]));
    }

    private ArgumentValidationException translateInvalidRebase(RpcInvalidRebase error) {
        switch (error.getReason()) {
            default: {
                log.warn("Unexpected InvalidRebase error: {}", (Object)error.getReason());
            }
            case COMMITTER_EMAIL_BLANK: {
                return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.request.invalid.committer.email", new Object[0]));
            }
            case COMMITTER_NAME_BLANK: 
        }
        return new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.request.invalid.committer.name", new Object[0]));
    }

    private GitRebaseException translateNonFastForwardUpdate() {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.git.rebase.outofdate", new Object[]{this.repository.getProject().getKey(), this.repository.getSlug(), this.branch});
        GitNonFastForwardUpdateRejectedException cause = new GitNonFastForwardUpdateRejectedException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.concurrent", new Object[0]), this.branch);
        return new GitRebaseException(message, (Throwable)cause);
    }

    private GitRebaseException translateRebaseConflicted() {
        return new GitRebaseException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.conflict", new Object[0]));
    }

    private GitRebaseException translateRebaseFailed(Throwable cause) {
        return new GitRebaseException(this.i18nService.createKeyedMessage("bitbucket.git.rebase.failed", new Object[0]), cause);
    }
}

