/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.mesh.rpc.MetadataKeys;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.scm.git.mesh.MetadataProvider;
import io.grpc.Metadata;
import jakarta.annotation.Nonnull;
import org.slf4j.MDC;

public class RequestMetadataProvider
implements MetadataProvider {
    private final AuthenticationContext authenticationContext;
    private final RequestManager requestManager;

    public RequestMetadataProvider(AuthenticationContext authenticationContext, RequestManager requestManager) {
        this.authenticationContext = authenticationContext;
        this.requestManager = requestManager;
    }

    @Override
    public void apply(@Nonnull Metadata metadata) {
        String requestId;
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            metadata.put(MetadataKeys.KEY_REMOTE_USER, (Object)user.getName());
        }
        if ((requestId = this.getRequestId()) != null) {
            metadata.put(MetadataKeys.KEY_REMOTE_REQUEST, (Object)requestId);
        }
    }

    private String getRequestId() {
        String requestId = this.requestManager.getRequestId();
        if (requestId == null) {
            return MDC.get((String)"a-request-id");
        }
        return requestId;
    }
}

