/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevertInvalidParentNumber;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevertRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.revert.GitRevertException;
import com.atlassian.stash.internal.scm.git.mesh.SigningErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

class RevertErrorTranslator
extends SigningErrorTranslator {
    private final RpcRevertRequest request;

    RevertErrorTranslator(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull RpcRevertRequest request) {
        super(Objects.requireNonNull(i18nService, "i18nService"), Objects.requireNonNull(repository, "repository"));
        this.request = Objects.requireNonNull(request, "request");
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case INVALID_BRANCH_NAME: {
                return new GitRevertException(this.i18nService.createKeyedMessage("bitbucket.git.revert.duplicateref", new Object[]{this.request.getTargetBranch(), this.repository}));
            }
            case REVERT_CONFLICTED: {
                return new GitRevertException(this.i18nService.createKeyedMessage("bitbucket.git.revert.conflict", new Object[]{error.getRevertConflicted().getCommitId(), this.repository}));
            }
            case REVERT_INVALID_PARENT_NUMBER: {
                RpcRevertInvalidParentNumber revertInvalidParentNumber = error.getRevertInvalidParentNumber();
                int mergedCommitParentNumber = revertInvalidParentNumber.getMergedCommitParentNumber();
                String commitId = revertInvalidParentNumber.getCommitId();
                return new GitRevertException(this.i18nService.createKeyedMessage("bitbucket.git.revert.invalidparentnumber", new Object[]{commitId, mergedCommitParentNumber, this.repository}));
            }
            case REVERT_FAILED: {
                return new GitRevertException(this.i18nService.createKeyedMessage("bitbucket.git.revert.commandfailed", new Object[]{error.getRevertFailed().getCommitId(), this.repository}));
            }
        }
        return super.translate(error, cause);
    }
}

